/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.traces;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.ballerinalang.langserver.extensions.ballerina.traces.BallerinaTraceService;
import org.ballerinalang.langserver.extensions.ballerina.traces.LogParser;
import org.ballerinalang.langserver.extensions.ballerina.traces.TraceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener {
    private ServerSocket listenSocket;
    private BufferedReader logReader;
    private BallerinaTraceService ballerinaTraceService;
    private static final Logger logger = LoggerFactory.getLogger(Listener.class);

    public Listener(BallerinaTraceService traceService) {
        this.ballerinaTraceService = traceService;
    }

    public int startListener() {
        try {
            this.listenSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            logger.error("Error starting network logs listener", (Throwable)e);
            return 0;
        }
        Runnable listener = () -> {
            while (!this.listenSocket.isClosed()) {
                try {
                    String line;
                    Socket dataSocket = this.listenSocket.accept();
                    this.logReader = new BufferedReader(new InputStreamReader(dataSocket.getInputStream(), "UTF-8"));
                    while ((line = this.logReader.readLine()) != null) {
                        String rawMessage;
                        JsonObject record = new JsonParser().parse(line).getAsJsonObject();
                        try {
                            rawMessage = record.get("message").getAsString();
                        }
                        catch (Exception e) {
                            rawMessage = "";
                        }
                        TraceRecord traceRecord = new TraceRecord(LogParser.fromString(rawMessage), record, rawMessage);
                        this.ballerinaTraceService.pushLogToClient(traceRecord);
                    }
                }
                catch (IOException e) {
                    logger.error("Error listening to network logs", (Throwable)e);
                }
            }
        };
        Thread serverThread = new Thread(listener);
        serverThread.start();
        return this.listenSocket.getLocalPort();
    }

    public void stopListener() {
        try {
            if (this.logReader != null) {
                this.logReader.close();
            }
            if (this.listenSocket != null) {
                this.listenSocket.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing trace logs listener", (Throwable)e);
        }
    }
}

