/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.signature;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.LSNodeVisitor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class SignatureTreeVisitor
extends LSNodeVisitor {
    private SymbolEnv symbolEnv;
    private SymbolResolver symbolResolver;
    private boolean terminateVisitor = false;
    private SymbolTable symTable;
    private Position cursorPosition;
    private LSContext lsContext;
    private Deque<DiagnosticPos> blockPositionStack = new ArrayDeque<DiagnosticPos>();

    public SignatureTreeVisitor(LSContext context) {
        this.lsContext = context;
        this.cursorPosition = ((TextDocumentPositionParams)context.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        this.symTable = SymbolTable.getInstance((CompilerContext)compilerContext);
        this.symbolResolver = SymbolResolver.getInstance((CompilerContext)compilerContext);
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        SymbolEnv pkgEnv;
        String relativePath = (String)this.lsContext.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        BLangPackage sourceOwnerPkg = CommonUtil.getSourceOwnerBLangPackage(relativePath, pkgNode);
        if (sourceOwnerPkg.symbol == null) {
            Optional<SymbolEnv> first = this.symTable.pkgEnvMap.entrySet().stream().filter(s -> ((BPackageSymbol)s.getKey()).pkgID.equals((Object)sourceOwnerPkg.packageID)).map(Map.Entry::getValue).findFirst();
            pkgEnv = first.orElse(null);
        } else {
            pkgEnv = (SymbolEnv)this.symTable.pkgEnvMap.get(sourceOwnerPkg.symbol);
        }
        List<TopLevelNode> topLevelNodes = CommonUtil.getCurrentFileTopLevelNodes(sourceOwnerPkg, this.lsContext);
        topLevelNodes.stream().filter(CommonUtil.checkInvalidTypesDefs()).forEach(topLevelNode -> this.acceptNode((BLangNode)topLevelNode, pkgEnv));
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        if (typeDefinition.annAttachments != null) {
            typeDefinition.annAttachments.forEach(s -> this.acceptNode((BLangNode)s, this.symbolEnv));
        }
        this.acceptNode((BLangNode)typeDefinition.typeNode, this.symbolEnv);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        objectTypeNode.functions.stream().filter(bLangFunction -> !bLangFunction.flagSet.contains(Flag.INTERFACE)).forEach(bLangFunction -> this.acceptNode((BLangNode)bLangFunction, this.symbolEnv));
    }

    @Override
    public void visit(BLangFunction funcNode) {
        BInvokableSymbol funcSymbol = funcNode.symbol;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv((BLangFunction)funcNode, (Scope)funcSymbol.scope, (SymbolEnv)this.symbolEnv);
        this.blockPositionStack.push(funcNode.pos);
        this.acceptNode((BLangNode)funcNode.body, funcEnv);
        this.blockPositionStack.pop();
        if (this.terminateVisitor && !funcNode.workers.isEmpty()) {
            this.terminateVisitor = false;
        }
        funcNode.workers.forEach(e -> this.acceptNode((BLangNode)e, funcEnv));
    }

    @Override
    public void visit(BLangService serviceNode) {
        BLangObjectTypeNode serviceType = (BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode;
        ArrayList<Object> serviceContent = new ArrayList<Object>();
        SymbolEnv serviceEnv = SymbolEnv.createPkgLevelSymbolEnv((BLangNode)serviceNode, (Scope)serviceType.symbol.scope, (SymbolEnv)this.symbolEnv);
        List serviceFunctions = ((BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode).getFunctions();
        List serviceFields = serviceType.getFields().stream().map(simpleVar -> (BLangSimpleVariable)simpleVar).collect(Collectors.toList());
        List annAttachments = serviceNode.annAttachments;
        serviceContent.addAll(serviceFunctions);
        serviceContent.addAll(serviceFields);
        serviceContent.addAll(annAttachments);
        serviceContent.sort(new CommonUtil.BLangNodeComparator());
        serviceContent.forEach(serviceField -> this.acceptNode((BLangNode)serviceField, serviceEnv));
    }

    @Override
    public void visit(BLangAnnotationAttachment attachment) {
        SymbolEnv annotationAttachmentEnv = new SymbolEnv((BLangNode)attachment, this.symbolEnv.scope);
        this.symbolEnv.copyTo(annotationAttachmentEnv);
        PackageID packageID = attachment.annotationSymbol.pkgID;
        if (packageID.getOrgName().getValue().equals("ballerina") && packageID.getName().getValue().equals("grpc") && attachment.annotationName.getValue().equals("ServiceDescriptor")) {
            return;
        }
        this.blockPositionStack.push(attachment.pos);
        if (!this.terminateVisitor && this.isCursorWithinBlock()) {
            this.populateSymbols(this.symbolResolver.getAllVisibleInScopeSymbols(annotationAttachmentEnv));
        }
        this.blockPositionStack.pop();
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv((BLangBlockStmt)blockNode, (SymbolEnv)this.symbolEnv);
        blockNode.stmts.forEach(stmt -> this.acceptNode((BLangNode)stmt, blockEnv));
        if (!this.terminateVisitor && this.isCursorWithinBlock()) {
            Map visibleSymbolEntries = this.symbolResolver.getAllVisibleInScopeSymbols(blockEnv);
            this.populateSymbols(visibleSymbolEntries);
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv((BLangFunctionBody)blockFuncBody, (SymbolEnv)this.symbolEnv);
        blockFuncBody.stmts.forEach(stmt -> this.acceptNode((BLangNode)stmt, blockEnv));
        if (!this.terminateVisitor && this.isCursorWithinBlock()) {
            Map visibleSymbolEntries = this.symbolResolver.getAllVisibleInScopeSymbols(blockEnv);
            this.populateSymbols(visibleSymbolEntries);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        this.acceptNode((BLangNode)varDefNode.var, this.symbolEnv);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.blockPositionStack.push(ifNode.pos);
        this.acceptNode((BLangNode)ifNode.body, this.symbolEnv);
        this.blockPositionStack.pop();
        if (ifNode.elseStmt != null) {
            this.blockPositionStack.push(ifNode.elseStmt.pos);
            this.acceptNode((BLangNode)ifNode.elseStmt, this.symbolEnv);
            this.blockPositionStack.pop();
        }
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.blockPositionStack.push(foreach.pos);
        this.acceptNode((BLangNode)foreach.body, this.symbolEnv);
        this.blockPositionStack.pop();
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.blockPositionStack.push(whileNode.pos);
        this.acceptNode((BLangNode)whileNode.body, this.symbolEnv);
        this.blockPositionStack.pop();
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.blockPositionStack.push(transactionNode.transactionBody.pos);
        this.acceptNode((BLangNode)transactionNode.transactionBody, this.symbolEnv);
        this.blockPositionStack.pop();
        if (transactionNode.onRetryBody != null) {
            this.blockPositionStack.push(transactionNode.onRetryBody.pos);
            this.acceptNode((BLangNode)transactionNode.onRetryBody, this.symbolEnv);
            this.blockPositionStack.pop();
        }
    }

    @Override
    public void visit(BLangCompoundAssignment assignment) {
        this.blockPositionStack.push(assignment.pos);
        this.acceptNode((BLangNode)assignment.varRef, this.symbolEnv);
        this.blockPositionStack.pop();
        if (assignment.expr != null) {
            this.blockPositionStack.push(assignment.expr.pos);
            this.acceptNode((BLangNode)assignment.expr, this.symbolEnv);
            this.blockPositionStack.pop();
        }
    }

    @Override
    public void visit(BLangSimpleVariable variable) {
        if (variable.expr != null) {
            this.blockPositionStack.push(variable.expr.pos);
            this.acceptNode((BLangNode)variable.expr, this.symbolEnv);
            this.blockPositionStack.pop();
        }
    }

    @Override
    public void visit(BLangTypeInit typeInit) {
        if (!this.terminateVisitor && this.isCursorWithinBlock()) {
            Map visibleSymbolEntries = this.symbolResolver.getAllVisibleInScopeSymbols(this.symbolEnv);
            this.populateSymbols(visibleSymbolEntries);
        }
    }

    private void acceptNode(BLangNode node, SymbolEnv env) {
        if (this.terminateVisitor) {
            return;
        }
        SymbolEnv prevEnv = this.symbolEnv;
        this.symbolEnv = env;
        node.accept((BLangNodeVisitor)this);
        this.symbolEnv = prevEnv;
    }

    private boolean isCursorWithinBlock() {
        if (this.blockPositionStack.isEmpty()) {
            return false;
        }
        DiagnosticPos blockPosition = CommonUtil.toZeroBasedPosition(this.blockPositionStack.peek());
        int cursorLine = this.cursorPosition.getLine();
        int cursorColumn = this.cursorPosition.getCharacter();
        int nodeStrtLine = blockPosition.getStartLine();
        int nodeEndLine = blockPosition.getEndLine();
        int nodeStrtColumn = blockPosition.getStartColumn();
        int nodeEndColumn = blockPosition.getEndColumn();
        int isAfterBlockStart = nodeStrtLine == cursorLine ? cursorColumn - nodeStrtColumn : cursorLine - nodeStrtLine;
        int isBeforeBlockEnd = nodeEndLine == cursorLine ? nodeEndColumn - cursorColumn : nodeEndLine - cursorLine;
        return isAfterBlockStart > 0 && isBeforeBlockEnd > 0;
    }

    private void populateSymbols(Map<Name, List<Scope.ScopeEntry>> symbolEntries) {
        this.terminateVisitor = true;
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>();
        for (Map.Entry<Name, List<Scope.ScopeEntry>> entry : symbolEntries.entrySet()) {
            List<Scope.ScopeEntry> entryList = entry.getValue();
            ArrayList<Scope.ScopeEntry> symbolCompletionItems = new ArrayList<Scope.ScopeEntry>(entryList);
            visibleSymbols.addAll(symbolCompletionItems);
        }
        this.lsContext.put(CommonKeys.VISIBLE_SYMBOLS_KEY, visibleSymbols);
    }
}

