/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.exception.LSStdlibCacheException;
import org.ballerinalang.langserver.util.definition.LSStandardLibCache;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.ballerinalang.langserver.util.references.SymbolReferenceFindingVisitor;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.Location;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class DefinitionUtil {
    public static List<Location> getDefinition(LSContext context) throws WorkspaceDocumentException, CompilationFailedException, LSStdlibCacheException {
        List<BLangPackage> modules = ReferencesUtil.findCursorTokenAndCompileModules(context, false);
        ReferencesUtil.findReferences(modules, context);
        SymbolReferencesModel referencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        if (!referencesModel.getDefinitions().isEmpty()) {
            return ReferencesUtil.getLocations(Collections.singletonList(referencesModel.getDefinitions().get(0)), (String)context.get(DocumentServiceKeys.SOURCE_ROOT_KEY));
        }
        Optional<SymbolReferencesModel.Reference> symbolAtCursor = referencesModel.getReferenceAtCursor();
        PackageID pkgID = symbolAtCursor.get().getSymbol().pkgID;
        if (DefinitionUtil.isStandardLibModule(pkgID)) {
            return DefinitionUtil.getStdLibDefinitionLocations(context, pkgID, symbolAtCursor.get());
        }
        String symbolPkgName = symbolAtCursor.get().getSymbolPkgName();
        Optional<BLangPackage> module = modules.stream().filter(bLangPackage -> bLangPackage.symbol.getName().getValue().equals(symbolPkgName)).findAny();
        if (!module.isPresent()) {
            return new ArrayList<Location>();
        }
        for (BLangCompilationUnit compilationUnit : module.get().getCompilationUnits()) {
            SymbolReferenceFindingVisitor refVisitor = new SymbolReferenceFindingVisitor(context, symbolPkgName);
            refVisitor.visit(compilationUnit);
            if (referencesModel.getDefinitions().isEmpty()) continue;
            break;
        }
        return ReferencesUtil.getLocations(referencesModel.getDefinitions(), (String)context.get(DocumentServiceKeys.SOURCE_ROOT_KEY));
    }

    private static boolean isStandardLibModule(PackageID packageID) {
        String orgName = packageID.getOrgName().getValue();
        return "ballerina".equals(orgName) || "ballerinax".equals(orgName);
    }

    private static List<Location> getStdLibDefinitionLocations(LSContext context, PackageID packageID, SymbolReferencesModel.Reference symbolAtCursor) throws LSStdlibCacheException {
        LSStandardLibCache stdLibCache = LSStandardLibCache.getInstance();
        List<TopLevelNode> definitions = stdLibCache.getTopLevelNodesForModule(context, packageID);
        TopLevelNode extractedDef = null;
        if (symbolAtCursor.getSymbol() instanceof BInvokableSymbol && (((BInvokableSymbol)symbolAtCursor.getSymbol()).flags & 8) == 8) {
            return DefinitionUtil.getStdLibInvocationLocation((BInvokableSymbol)symbolAtCursor.getSymbol(), definitions);
        }
        if (symbolAtCursor.getSymbol() instanceof BVarSymbol && symbolAtCursor.getSymbol().owner instanceof BObjectTypeSymbol) {
            return DefinitionUtil.getStdLibFieldLocation((BVarSymbol)symbolAtCursor.getSymbol(), definitions);
        }
        for (TopLevelNode topLevelNode : definitions) {
            Pair<String, BSymbol> nameSymbolPair = DefinitionUtil.getTopLevelNodeNameSymbolPair(topLevelNode);
            if (!((String)nameSymbolPair.getLeft()).equals(symbolAtCursor.getSymbol().name.value)) continue;
            extractedDef = topLevelNode;
            break;
        }
        if (extractedDef != null) {
            Pair<String, BSymbol> nameSymbolPair = DefinitionUtil.getTopLevelNodeNameSymbolPair(extractedDef);
            DiagnosticPos diagnosticPos = DefinitionUtil.getTopLevelNodePosition(extractedDef);
            return DefinitionUtil.prepareLocations(diagnosticPos, (BSymbol)nameSymbolPair.getRight(), (BLangNode)extractedDef);
        }
        return new ArrayList<Location>();
    }

    private static List<Location> prepareLocations(DiagnosticPos diagPos, BSymbol symbol, BLangNode node) throws LSStdlibCacheException {
        String sourceRoot = LSStandardLibCache.getInstance().getCachedStdlibRoot(diagPos.src.pkgID.name.value).toString();
        SymbolReferencesModel.Reference reference = new SymbolReferencesModel.Reference(diagPos, symbol, node);
        return ReferencesUtil.getLocations(Collections.singletonList(reference), sourceRoot);
    }

    private static List<Location> getStdLibInvocationLocation(BInvokableSymbol symbol, List<TopLevelNode> topLevelNodes) throws LSStdlibCacheException {
        Optional<BLangTypeDefinition> objectNode = DefinitionUtil.getOwnerObjectTypeNode((BVarSymbol)symbol, topLevelNodes);
        if (!objectNode.isPresent()) {
            return new ArrayList<Location>();
        }
        BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)objectNode.get().typeNode;
        String symbolName = CommonUtil.getSymbolName((BSymbol)symbol);
        if ("__init".equals(symbolName)) {
            BLangFunction initFunction = objectTypeNode.initFunction;
            if (initFunction.symbol == null) {
                DiagnosticPos pos = CommonUtil.toZeroBasedPosition(objectNode.get().getName().pos);
                return DefinitionUtil.prepareLocations(pos, (BSymbol)objectNode.get().symbol, (BLangNode)objectTypeNode);
            }
            DiagnosticPos pos = CommonUtil.toZeroBasedPosition(initFunction.getName().pos);
            return DefinitionUtil.prepareLocations(pos, (BSymbol)initFunction.symbol, (BLangNode)initFunction);
        }
        for (BLangFunction function : objectTypeNode.functions) {
            if (!symbolName.equals(function.getName().getValue())) continue;
            DiagnosticPos pos = CommonUtil.toZeroBasedPosition(function.name.pos);
            return DefinitionUtil.prepareLocations(pos, (BSymbol)symbol, (BLangNode)function);
        }
        return new ArrayList<Location>();
    }

    private static List<Location> getStdLibFieldLocation(BVarSymbol symbol, List<TopLevelNode> topLevelNodes) throws LSStdlibCacheException {
        Optional<BLangTypeDefinition> objectNode = DefinitionUtil.getOwnerObjectTypeNode(symbol, topLevelNodes);
        if (!objectNode.isPresent()) {
            return new ArrayList<Location>();
        }
        BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)objectNode.get().typeNode;
        String symbolName = CommonUtil.getSymbolName((BSymbol)symbol);
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            if (!symbolName.equals(field.getName().getValue())) continue;
            DiagnosticPos pos = CommonUtil.toZeroBasedPosition(field.name.pos);
            return DefinitionUtil.prepareLocations(pos, (BSymbol)symbol, (BLangNode)field);
        }
        return new ArrayList<Location>();
    }

    private static Optional<BLangTypeDefinition> getOwnerObjectTypeNode(BVarSymbol symbol, List<TopLevelNode> topLevelNodes) {
        if (!(symbol.owner instanceof BObjectTypeSymbol)) {
            return Optional.empty();
        }
        String objectTypeName = symbol.owner.getName().getValue();
        TopLevelNode objectNode = topLevelNodes.parallelStream().filter(topLevelNode -> {
            Pair<String, BSymbol> nameSymbolPair;
            try {
                nameSymbolPair = DefinitionUtil.getTopLevelNodeNameSymbolPair(topLevelNode);
            }
            catch (LSStdlibCacheException e) {
                return false;
            }
            return objectTypeName.equals(nameSymbolPair.getLeft());
        }).findFirst().orElse(null);
        if (!(objectNode instanceof BLangTypeDefinition) || !(((BLangTypeDefinition)objectNode).typeNode instanceof BLangObjectTypeNode)) {
            return Optional.empty();
        }
        return Optional.of((BLangTypeDefinition)objectNode);
    }

    private static Pair<String, BSymbol> getTopLevelNodeNameSymbolPair(TopLevelNode topLevelNode) throws LSStdlibCacheException {
        switch (topLevelNode.getKind()) {
            case FUNCTION: {
                BLangFunction funcNode = (BLangFunction)topLevelNode;
                return Pair.of((Object)funcNode.getName().getValue(), (Object)funcNode.symbol);
            }
            case TYPE_DEFINITION: {
                BLangTypeDefinition defNode = (BLangTypeDefinition)topLevelNode;
                return Pair.of((Object)defNode.getName().getValue(), (Object)defNode.symbol);
            }
            case CONSTANT: {
                BLangConstant constNode = (BLangConstant)topLevelNode;
                return Pair.of((Object)constNode.getName().getValue(), (Object)constNode.symbol);
            }
            case ANNOTATION: {
                BLangAnnotation annotationNode = (BLangAnnotation)topLevelNode;
                return Pair.of((Object)annotationNode.getName().getValue(), (Object)annotationNode.symbol);
            }
        }
        throw new LSStdlibCacheException("Could not find a valid Top Level Node" + topLevelNode.getKind().name());
    }

    private static DiagnosticPos getTopLevelNodePosition(TopLevelNode topLevelNode) throws LSStdlibCacheException {
        switch (topLevelNode.getKind()) {
            case FUNCTION: {
                BLangFunction funcNode = (BLangFunction)topLevelNode;
                return CommonUtil.toZeroBasedPosition(funcNode.name.pos);
            }
            case TYPE_DEFINITION: {
                BLangTypeDefinition defNode = (BLangTypeDefinition)topLevelNode;
                return CommonUtil.toZeroBasedPosition(defNode.name.pos);
            }
            case CONSTANT: {
                BLangConstant constNode = (BLangConstant)topLevelNode;
                return CommonUtil.toZeroBasedPosition(constNode.name.pos);
            }
            case ANNOTATION: {
                BLangAnnotation annotationNode = (BLangAnnotation)topLevelNode;
                return CommonUtil.toZeroBasedPosition(annotationNode.name.pos);
            }
        }
        throw new LSStdlibCacheException("Could not find Position for Node" + topLevelNode.getKind().name());
    }
}

