/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util.references;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class SymbolReferencesModel {
    private List<Reference> references = new ArrayList<Reference>();
    private List<Reference> definitions = new ArrayList<Reference>();
    private Reference referenceAtCursor = null;

    public List<Reference> getReferences() {
        return this.references;
    }

    public List<Reference> getDefinitions() {
        return this.definitions;
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    public void addDefinition(Reference definition) {
        this.definitions.add(definition);
    }

    public Optional<Reference> getReferenceAtCursor() {
        return Optional.ofNullable(this.referenceAtCursor);
    }

    public void setReferenceAtCursor(Reference symbol) {
        this.referenceAtCursor = symbol;
    }

    public static class Reference {
        private DiagnosticPos position;
        private BSymbol symbol;
        private BLangNode bLangNode;
        private String compilationUnit;
        private String symbolPkgName;
        private String sourcePkgName;

        public Reference(DiagnosticPos position, BSymbol symbol, BLangNode bLangNode) {
            this.position = position;
            this.symbol = symbol;
            this.bLangNode = bLangNode;
            this.symbolPkgName = symbol != null ? symbol.pkgID.nameComps.stream().map(Name::getValue).collect(Collectors.joining(".")) : "";
            this.compilationUnit = position.src.cUnitName;
            this.sourcePkgName = position.src.pkgID.name.value;
        }

        public DiagnosticPos getPosition() {
            return this.position;
        }

        public String getCompilationUnit() {
            return this.compilationUnit;
        }

        public String getSourcePkgName() {
            return this.sourcePkgName;
        }

        public String getSymbolPkgName() {
            return this.symbolPkgName;
        }

        public BSymbol getSymbol() {
            return this.symbol;
        }

        public BLangNode getbLangNode() {
            return this.bLangNode;
        }
    }
}

