/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.common.data.types.LongString;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Queue;
import io.ballerina.messaging.broker.core.selector.BooleanExpression;
import io.ballerina.messaging.broker.core.selector.generated.MessageFilter;
import java.util.Objects;

public final class Binding {
    public static final ShortString JMS_SELECTOR_ARGUMENT = ShortString.parseString((String)"x-filter-jms-selector");
    private final Queue queue;
    private final String bindingPattern;
    private final FieldTable arguments;
    private final BooleanExpression filterExpression;
    private final LongString filterString;

    Binding(Queue queue, String bindingPattern, FieldTable arguments) throws BrokerException {
        this.queue = queue;
        this.bindingPattern = bindingPattern;
        this.arguments = arguments;
        LongString selector = null;
        try {
            FieldValue fieldValue = arguments.getValue(JMS_SELECTOR_ARGUMENT);
            if (Objects.nonNull(fieldValue) && fieldValue.getType() == FieldValue.Type.LONG_STRING && !(selector = (LongString)fieldValue.getValue()).isEmpty()) {
                MessageFilter messageFilter = new MessageFilter(selector.toString());
                this.filterExpression = messageFilter.parse();
                this.filterString = selector;
            } else {
                this.filterExpression = null;
                this.filterString = null;
            }
        }
        catch (Exception e) {
            throw new BrokerException("Error parsing the message filter string [ " + selector + " ]", e);
        }
    }

    public Queue getQueue() {
        return this.queue;
    }

    public String getBindingPattern() {
        return this.bindingPattern;
    }

    public FieldValue getArgument(ShortString propertyName) {
        return this.arguments.getValue(propertyName);
    }

    public FieldTable getArguments() {
        return this.arguments;
    }

    BooleanExpression getFilterExpression() {
        return this.filterExpression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Binding) {
            return this.bindingPattern.equals(((Binding)obj).bindingPattern) && this.getQueue().equals(((Binding)obj).getQueue()) && Objects.equals(this.filterString, ((Binding)obj).filterString);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.bindingPattern, this.getQueue(), this.filterString);
    }

    public String toString() {
        return "Binding{queue=" + this.queue + ", bindingPattern='" + this.bindingPattern + '\'' + '}';
    }
}

