/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.util.function.ThrowingConsumer;
import io.ballerina.messaging.broker.core.Binding;
import io.ballerina.messaging.broker.core.BindingSet;
import io.ballerina.messaging.broker.core.BindingsRegistryListener;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.Queue;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.QueueRegistry;
import io.ballerina.messaging.broker.core.store.dao.BindingDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(BindingsRegistry.class);
    private final Map<String, BindingSet> bindingPatternToBindingsMap = new HashMap<String, BindingSet>();
    private final Exchange exchange;
    private final BindingDao bindingDao;
    private final Map<String, BindingSet> unmodifiableBindingSetView;
    private final BindingDeleteListener bindingDeleteListener;
    private List<BindingsRegistryListener> bindingsRegistryListeners;

    BindingsRegistry(Exchange exchange, BindingDao bindingDao) {
        this.exchange = exchange;
        this.bindingDao = bindingDao;
        this.unmodifiableBindingSetView = Collections.unmodifiableMap(this.bindingPatternToBindingsMap);
        this.bindingDeleteListener = new BindingDeleteListener();
        this.bindingsRegistryListeners = new ArrayList<BindingsRegistryListener>();
    }

    void bind(QueueHandler queueHandler, String bindingKey, FieldTable arguments) throws BrokerException, ValidationException {
        Queue queue;
        Binding binding;
        BindingSet bindingSet = this.bindingPatternToBindingsMap.computeIfAbsent(bindingKey, k -> new BindingSet());
        boolean success = bindingSet.add(binding = new Binding(queue = queueHandler.getUnmodifiableQueue(), bindingKey, arguments));
        if (success) {
            queueHandler.addBinding(binding, this.bindingDeleteListener);
            if (queue.isDurable()) {
                this.bindingDao.persist(this.exchange.getName(), binding);
            }
        }
        LOGGER.debug("Binding added for queue {} with pattern {}", (Object)queueHandler, (Object)bindingKey);
        this.notifyOnBind(bindingKey);
    }

    void unbind(Queue queue, String routingKey) throws BrokerException {
        BindingSet bindingSet = this.bindingPatternToBindingsMap.get(routingKey);
        if (queue.isDurable()) {
            this.bindingDao.delete(queue.getName(), routingKey, this.exchange.getName());
        }
        bindingSet.remove(queue);
        if (bindingSet.isEmpty()) {
            this.bindingPatternToBindingsMap.remove(routingKey);
        }
        LOGGER.debug("Binding removed from queue {} with pattern {}", (Object)queue, (Object)routingKey);
        this.notifyOnUnbind(routingKey, this.getBindingsForRoute(routingKey).isEmpty());
    }

    BindingSet getBindingsForRoute(String routingKey) {
        BindingSet bindingSet = this.bindingPatternToBindingsMap.get(routingKey);
        if (bindingSet == null) {
            bindingSet = BindingSet.emptySet();
        }
        return bindingSet;
    }

    boolean isEmpty() {
        return this.bindingPatternToBindingsMap.isEmpty();
    }

    public void retrieveAllBindingsForExchange(QueueRegistry queueRegistry) throws BrokerException {
        this.bindingDao.retrieveBindingsForExchange(this.exchange.getName(), (queueName, bindingKey, filterTable) -> {
            QueueHandler queueHandler = queueRegistry.getQueueHandler(queueName);
            Binding binding = new Binding(queueHandler.getUnmodifiableQueue(), bindingKey, filterTable);
            BindingSet bindingSet = this.bindingPatternToBindingsMap.computeIfAbsent(bindingKey, k -> new BindingSet());
            bindingSet.add(binding);
            queueHandler.addBinding(binding, this.bindingDeleteListener);
            this.notifyOnRetrieveAllBindingsForExchange(bindingKey);
        });
    }

    public Map<String, BindingSet> getAllBindings() {
        return this.unmodifiableBindingSetView;
    }

    public void addBindingsRegistryListeners(BindingsRegistryListener listener) {
        this.bindingsRegistryListeners.add(listener);
    }

    private void notifyOnBind(String routingKey) {
        for (BindingsRegistryListener listener : this.bindingsRegistryListeners) {
            listener.onBind(routingKey);
        }
    }

    private void notifyOnUnbind(String routingKey, boolean isEmpty) {
        for (BindingsRegistryListener listener : this.bindingsRegistryListeners) {
            listener.onUnbind(routingKey, isEmpty);
        }
    }

    private void notifyOnRetrieveAllBindingsForExchange(String routingKey) {
        for (BindingsRegistryListener listener : this.bindingsRegistryListeners) {
            listener.onRetrieveAllBindingsForExchange(routingKey);
        }
    }

    private class BindingDeleteListener
    implements ThrowingConsumer<Binding, BrokerException> {
        private BindingDeleteListener() {
        }

        public void accept(Binding binding) throws BrokerException {
            BindingsRegistry.this.unbind(binding.getQueue(), binding.getBindingPattern());
        }
    }
}

