/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.core.BindingSet;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.UniqueIdGenerator;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;

public interface Broker {
    public static final UniqueIdGenerator MESSAGE_ID_GENERATOR = new UniqueIdGenerator();

    public void publish(Message var1) throws BrokerException;

    public void acknowledge(String var1, DetachableMessage var2) throws BrokerException;

    public Set<QueueHandler> enqueue(Xid var1, Message var2) throws BrokerException;

    public QueueHandler dequeue(Xid var1, String var2, DetachableMessage var3) throws BrokerException;

    public void addConsumer(Consumer var1) throws BrokerException;

    public boolean removeConsumer(Consumer var1);

    public void declareExchange(String var1, String var2, boolean var3, boolean var4) throws BrokerException, ValidationException;

    public void createExchange(String var1, String var2, boolean var3) throws BrokerException, ValidationException;

    public boolean deleteExchange(String var1, boolean var2) throws BrokerException, ValidationException, ResourceNotFoundException;

    public boolean createQueue(String var1, boolean var2, boolean var3, boolean var4) throws BrokerException, ValidationException;

    public int deleteQueue(String var1, boolean var2, boolean var3) throws BrokerException, ValidationException, ResourceNotFoundException;

    public boolean queueExists(String var1);

    public void bind(String var1, String var2, String var3, FieldTable var4) throws BrokerException, ValidationException;

    public void unbind(String var1, String var2, String var3) throws BrokerException, ValidationException;

    public void startMessageDelivery();

    public int purgeQueue(String var1) throws ResourceNotFoundException, ValidationException;

    public void stopMessageDelivery();

    public QueueHandler getQueue(String var1) throws BrokerException, ResourceNotFoundException;

    public static long getNextMessageId() {
        return MESSAGE_ID_GENERATOR.getNextId();
    }

    public void requeue(String var1, Message var2) throws BrokerException, ResourceNotFoundException;

    public Collection<QueueHandler> getAllQueues() throws BrokerException;

    public void shutdown();

    public Collection<Exchange> getAllExchanges() throws BrokerException;

    public void moveToDlc(String var1, Message var2) throws BrokerException;

    public Map<String, BindingSet> getAllBindingsForExchange(String var1) throws ValidationException;

    public Exchange getExchange(String var1) throws BrokerException;

    public BrokerTransaction newLocalTransaction();

    public BrokerTransaction newDistributedTransaction();

    public Set<QueueHandler> restoreDtxPreparedMessages(Xid var1, Collection<Message> var2) throws BrokerException;
}

