/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.ContentReader;
import java.util.ArrayList;
import java.util.List;

public class ChunkConverter {
    private int maxChunkSizeLimit;

    public ChunkConverter(int maxChunkSizeLimit) {
        this.maxChunkSizeLimit = maxChunkSizeLimit;
    }

    public List<ContentChunk> convert(List<ContentChunk> chunkList, long totalLength) {
        if (chunkList.isEmpty() || this.isChunksUnderLimit(chunkList)) {
            return chunkList;
        }
        ArrayList<ContentChunk> convertedChunks = new ArrayList<ContentChunk>();
        long pendingBytes = totalLength;
        long offset = 0L;
        ContentReader contentReader = new ContentReader(chunkList);
        while (pendingBytes > 0L) {
            long newBufferLength = Math.min(pendingBytes, (long)this.maxChunkSizeLimit);
            ContentChunk newChunk = new ContentChunk(offset, contentReader.getNextBytes((int)newBufferLength));
            convertedChunks.add(newChunk);
            pendingBytes -= newBufferLength;
            offset += newBufferLength;
        }
        return convertedChunks;
    }

    private boolean isChunksUnderLimit(List<ContentChunk> chunkList) {
        boolean allChunksUnderLimit = true;
        for (ContentChunk chunk : chunkList) {
            if (chunk.getByteBuf().readableBytes() <= this.maxChunkSizeLimit) continue;
            allChunksUnderLimit = false;
            break;
        }
        return allChunksUnderLimit;
    }
}

