/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;

public class ContentChunk {
    private final long offset;
    private final ByteBuf content;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Data holder class for content chunks.")
    public ContentChunk(long offset, ByteBuf content) {
        this.offset = offset;
        this.content = content;
    }

    public long getOffset() {
        return this.offset;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Data holder class for content chunks.")
    public ByteBuf getByteBuf() {
        return this.content;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.content.readableBytes()];
        this.content.getBytes(0, bytes);
        return bytes;
    }

    public void release() {
        this.content.release();
    }

    ContentChunk shallowCopy() {
        return new ContentChunk(this.offset, this.content.retainedSlice());
    }
}

