/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.core.ContentChunk;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;

class ContentReader {
    private List<ContentChunk> chunkList;
    private int currentChunkIndex = 0;
    private int sliceStart = 0;

    ContentReader(List<ContentChunk> chunkList) {
        this.chunkList = chunkList;
    }

    ByteBuf getNextBytes(int size) {
        ContentChunk currentChunk = this.chunkList.get(this.currentChunkIndex);
        ByteBuf chunkByteBuf = currentChunk.getByteBuf();
        int readableBytes = chunkByteBuf.readableBytes() - this.sliceStart;
        if (readableBytes == size) {
            ByteBuf slice = this.getSlice(chunkByteBuf, size);
            this.jumpToNextChunk();
            return slice;
        }
        if (readableBytes > size) {
            ByteBuf slice = this.getSlice(chunkByteBuf, size);
            this.sliceStart += size;
            return slice;
        }
        ByteBuf firstSlice = this.getSlice(chunkByteBuf, readableBytes);
        this.jumpToNextChunk();
        ByteBuf secondSlice = this.getNextBytes(size - readableBytes);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{firstSlice, secondSlice});
    }

    private void jumpToNextChunk() {
        ++this.currentChunkIndex;
        this.sliceStart = 0;
    }

    private ByteBuf getSlice(ByteBuf chunkByteBuf, int length) {
        return chunkByteBuf.slice(chunkByteBuf.readerIndex() + this.sliceStart, length);
    }
}

