/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.core.BindingSet;
import io.ballerina.messaging.broker.core.BindingsRegistry;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Queue;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.QueueRegistry;
import io.ballerina.messaging.broker.core.store.dao.BindingDao;
import io.ballerina.messaging.broker.core.store.dao.impl.NoOpBindingDao;
import java.util.Objects;

public abstract class Exchange {
    private final int hashCode;
    private final String name;
    private final Type type;
    private final BindingDao bindingDao;
    private final BindingsRegistry bindingsRegistry;

    protected Exchange(String name, Type type, BindingDao bindingDao) {
        this.name = name;
        this.type = type;
        this.hashCode = Objects.hash(new Object[]{name, type});
        this.bindingDao = bindingDao;
        this.bindingsRegistry = new BindingsRegistry(this, bindingDao);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    void bind(QueueHandler queueHandler, String routingKey, FieldTable arguments) throws BrokerException, ValidationException {
        this.bindingsRegistry.bind(queueHandler, routingKey, arguments);
    }

    void unbind(Queue queue, String routingKey) throws BrokerException {
        this.bindingsRegistry.unbind(queue, routingKey);
    }

    BindingSet getBindingsForRoute(String routingKey) {
        return this.bindingsRegistry.getBindingsForRoute(routingKey);
    }

    BindingsRegistry getBindingsRegistry() {
        return this.bindingsRegistry;
    }

    boolean isUnused() {
        return this.bindingsRegistry.isEmpty();
    }

    public boolean isDurable() {
        return !(this.bindingDao instanceof NoOpBindingDao);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Exchange && this.getName().equals(((Exchange)obj).getName()) && this.getType() == ((Exchange)obj).getType();
    }

    public void retrieveBindingsFromDb(QueueRegistry queueRegistry) throws BrokerException {
        this.bindingsRegistry.retrieveAllBindingsForExchange(queueRegistry);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Exchange{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        DIRECT("direct"),
        TOPIC("topic");

        String typeName;

        private Type(String name) {
            this.typeName = name;
        }

        public String toString() {
            return this.typeName;
        }

        public static Type from(String typeString) {
            if (typeString.equals(Type.DIRECT.typeName)) {
                return DIRECT;
            }
            if (typeString.equals(Type.TOPIC.typeName)) {
                return TOPIC;
            }
            throw new IllegalArgumentException("unknown exchange type: " + typeString);
        }
    }
}

