/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.QueueHandlerFactory;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import io.ballerina.messaging.broker.core.queue.MemQueueImpl;

public class MemBackedQueueHandlerFactory
implements QueueHandlerFactory {
    private final BrokerMetricManager metricManager;
    private final int nonDurableQueueMaxDepth;

    public MemBackedQueueHandlerFactory(BrokerMetricManager metricManager, BrokerCoreConfiguration configuration) {
        this.metricManager = metricManager;
        this.nonDurableQueueMaxDepth = Integer.parseInt(configuration.getNonDurableQueueMaxDepth());
    }

    @Override
    public QueueHandler createDurableQueueHandler(String queueName, boolean autoDelete) {
        return this.getQueueHandler(queueName, true, autoDelete);
    }

    @Override
    public QueueHandler createNonDurableQueueHandler(String queueName, boolean autoDelete) {
        return this.getQueueHandler(queueName, false, autoDelete);
    }

    private QueueHandler getQueueHandler(String queueName, boolean durable, boolean autoDelete) {
        MemQueueImpl queue = new MemQueueImpl(queueName, durable, this.nonDurableQueueMaxDepth, autoDelete);
        return new QueueHandler(queue, this.metricManager);
    }
}

