/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final Logger LOGGER = LoggerFactory.getLogger(Message.class);
    private Metadata metadata;
    private final List<ContentChunk> contentChunks;
    private final MessageDataHolder messageDataHolder;

    public Message(long internalId, Metadata metadata) {
        this(internalId, metadata, ConcurrentHashMap.newKeySet(), 0);
    }

    private Message(long internalId, Metadata metadata, Set<String> queueSet, int redeliveryCount) {
        this.metadata = metadata;
        this.contentChunks = new ArrayList<ContentChunk>();
        this.messageDataHolder = new MessageDataHolder(internalId, queueSet, redeliveryCount);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public List<ContentChunk> getContentChunks() {
        return Collections.unmodifiableList(this.contentChunks);
    }

    public void addChunk(ContentChunk contentChunk) {
        this.contentChunks.add(contentChunk);
    }

    public void release() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Release message with id: {}", (Object)this.getInternalId(), (Object)new Throwable());
        }
        for (ContentChunk contentChunk : this.contentChunks) {
            contentChunk.release();
        }
    }

    public Message shallowCopy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Shallow copy message id: {}", (Object)this.getInternalId(), (Object)new Throwable());
        }
        Message message = new Message(this.getInternalId(), this.metadata, this.getAttachedDurableQueues(), this.getRedeliveryCount());
        this.shallowCopyContent(message);
        return message;
    }

    public Message bareShallowCopy() {
        return new Message(this.getInternalId(), null, this.messageDataHolder.getAttachedQueues(), this.getRedeliveryCount());
    }

    public Message shallowCopyWith(long newMessageId, String routingKey, String exchangeName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Shallow copy message with id: {} newId: {}", new Object[]{this.getInternalId(), newMessageId, new Throwable()});
        }
        Message message = new Message(newMessageId, this.metadata.shallowCopyWith(routingKey, exchangeName));
        this.shallowCopyContent(message);
        return message;
    }

    private void shallowCopyContent(Message message) {
        this.contentChunks.stream().map(ContentChunk::shallowCopy).forEach(message::addChunk);
    }

    public void addAttachedDurableQueue(String queueName) {
        this.messageDataHolder.attachQueue(queueName);
    }

    public boolean hasAttachedDurableQueues() {
        return this.messageDataHolder.hasAttachedDurableQueues();
    }

    public Set<String> getAttachedDurableQueues() {
        return this.messageDataHolder.getAttachedQueues();
    }

    public long getInternalId() {
        return this.messageDataHolder.getInternalId();
    }

    public int setRedeliver() {
        return this.messageDataHolder.setRedeliver();
    }

    public int getRedeliveryCount() {
        return this.messageDataHolder.getRedeliveryCount();
    }

    public boolean isRedelivered() {
        return this.messageDataHolder.isRedelivered();
    }

    public DetachableMessage getDetachableMessage() {
        return this.messageDataHolder;
    }

    public String toString() {
        if (Objects.isNull(this.metadata)) {
            return "Bare message";
        }
        return this.metadata.toString();
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void clearData() {
        this.metadata = null;
        this.release();
        this.contentChunks.clear();
    }

    public boolean hasContent() {
        return Objects.nonNull(this.metadata);
    }

    private static class MessageDataHolder
    implements DetachableMessage {
        private final long internalId;
        private final Set<String> queueSet;
        private boolean redelivered = false;
        private int redeliveryCount;

        private MessageDataHolder(long internalId, Set<String> queueSet, int redeliveryCount) {
            this.internalId = internalId;
            this.queueSet = queueSet;
            this.redeliveryCount = redeliveryCount;
        }

        @Override
        public long getInternalId() {
            return this.internalId;
        }

        @Override
        public void removeAttachedDurableQueue(String queueName) {
            this.queueSet.remove(queueName);
        }

        @Override
        public boolean hasAttachedDurableQueues() {
            return !this.queueSet.isEmpty();
        }

        @Override
        public Set<String> getAttachedQueues() {
            return this.queueSet;
        }

        void attachQueue(String queueName) {
            this.queueSet.add(queueName);
        }

        int setRedeliver() {
            this.redelivered = true;
            return ++this.redeliveryCount;
        }

        int getRedeliveryCount() {
            return this.redeliveryCount;
        }

        boolean isRedelivered() {
            return this.redelivered;
        }
    }
}

