/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.QueueHandlerFactory;
import io.ballerina.messaging.broker.core.store.dao.QueueDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class QueueRegistry {
    private final Map<String, QueueHandler> queueHandlerMap = new HashMap<String, QueueHandler>();
    private final QueueDao queueDao;
    private final QueueHandlerFactory queueHandlerFactory;

    public QueueRegistry(QueueDao queueDao, QueueHandlerFactory queueHandlerFactory) throws BrokerException {
        this.queueDao = queueDao;
        this.queueHandlerFactory = queueHandlerFactory;
        this.retrieveQueuesFromDao();
    }

    QueueHandler getQueueHandler(String queueName) {
        return this.queueHandlerMap.get(queueName);
    }

    boolean addQueue(String queueName, boolean passive, boolean durable, boolean autoDelete) throws BrokerException {
        QueueHandler queueHandler = this.queueHandlerMap.get(queueName);
        if (passive) {
            if (Objects.isNull(queueHandler)) {
                throw new BrokerException("Queue [ " + queueName + " ] doesn't exists. Passive parameter is set, hence not creating the queue.");
            }
            return false;
        }
        if (Objects.isNull(queueHandler)) {
            if (durable) {
                queueHandler = this.queueHandlerFactory.createDurableQueueHandler(queueName, autoDelete);
                this.queueDao.persist(queueHandler.getUnmodifiableQueue());
            } else {
                queueHandler = this.queueHandlerFactory.createNonDurableQueueHandler(queueName, autoDelete);
            }
            this.queueHandlerMap.put(queueName, queueHandler);
            return true;
        }
        if (queueHandler.getUnmodifiableQueue().isDurable() != durable || queueHandler.getUnmodifiableQueue().isAutoDelete() != autoDelete) {
            throw new BrokerException("Existing queue [ " + queueName + " ] does not match given parameters.");
        }
        return false;
    }

    int removeQueue(String queueName, boolean ifUnused, boolean ifEmpty) throws BrokerException, ValidationException, ResourceNotFoundException {
        QueueHandler queueHandler = this.queueHandlerMap.get(queueName);
        if (queueHandler == null) {
            throw new ResourceNotFoundException("Queue [ " + queueName + " ] Not found");
        }
        if (ifUnused && !queueHandler.isUnused()) {
            throw new ValidationException("Cannot delete queue. Queue [ " + queueName + " ] has active consumers and the ifUnused parameter is set.");
        }
        if (ifEmpty && !queueHandler.isEmpty()) {
            throw new ValidationException("Cannot delete queue. Queue [ " + queueName + " ] is not empty and the ifEmpty parameter is set.");
        }
        this.queueHandlerMap.remove(queueName);
        this.queueDao.delete(queueHandler.getUnmodifiableQueue());
        return queueHandler.releaseResources();
    }

    private void retrieveQueuesFromDao() throws BrokerException {
        this.queueDao.retrieveAll(name -> {
            QueueHandler handler = this.queueHandlerFactory.createDurableQueueHandler(name, false);
            this.queueHandlerMap.putIfAbsent(name, handler);
        });
    }

    public Collection<QueueHandler> getAllQueues() {
        return this.queueHandlerMap.values();
    }

    void reloadQueuesOnBecomingActive() throws BrokerException {
        this.queueHandlerMap.clear();
        this.retrieveQueuesFromDao();
    }
}

