/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.auth.AuthManager;
import io.ballerina.messaging.broker.auth.authorization.AuthorizationHandler;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerFactory;
import io.ballerina.messaging.broker.core.SecureBrokerImpl;
import javax.security.auth.Subject;

public class SecureBrokerFactory
implements BrokerFactory {
    private final Broker broker;
    private final AuthorizationHandler authorizationHandler;

    public SecureBrokerFactory(StartupContext startupContext) {
        this.broker = (Broker)startupContext.getService(Broker.class);
        AuthManager authManager = (AuthManager)startupContext.getService(AuthManager.class);
        Authorizer authorizer = authManager.getAuthorizer();
        this.authorizationHandler = new AuthorizationHandler(authorizer);
    }

    @Override
    public Broker getBroker(Subject subject) {
        return new SecureBrokerImpl(this.broker, subject, this.authorizationHandler);
    }
}

