/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.authorization.AuthorizationHandler;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAction;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAuthScope;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceType;
import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.core.BindingSet;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerAuthException;
import io.ballerina.messaging.broker.core.BrokerAuthNotFoundException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import io.ballerina.messaging.broker.core.transaction.SecureBrokerTransaction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.transaction.xa.Xid;

public class SecureBrokerImpl
implements Broker {
    private final Broker broker;
    private final Subject subject;
    private final AuthorizationHandler authHandler;

    SecureBrokerImpl(Broker broker, Subject subject, AuthorizationHandler authHandler) {
        this.broker = broker;
        this.subject = subject;
        this.authHandler = authHandler;
    }

    @Override
    public void publish(Message message) throws BrokerException {
        try {
            this.authHandler.handle(ResourceAuthScope.EXCHANGES_PUBLISH, ResourceType.EXCHANGE, message.getMetadata().getExchangeName(), ResourceAction.PUBLISH, this.subject);
            this.broker.publish(message);
        }
        catch (AuthException e) {
            message.release();
            throw new BrokerAuthException(e.getMessage(), e);
        }
        catch (AuthNotFoundException e) {
            message.release();
            throw new BrokerAuthNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public void acknowledge(String queueName, DetachableMessage detachableMessage) throws BrokerException {
        this.broker.acknowledge(queueName, detachableMessage);
    }

    @Override
    public Set<QueueHandler> enqueue(Xid xid, Message message) throws BrokerException {
        return this.broker.enqueue(xid, message);
    }

    @Override
    public QueueHandler dequeue(Xid xid, String queueName, DetachableMessage detachableMessage) throws BrokerException {
        return this.broker.dequeue(xid, queueName, detachableMessage);
    }

    @Override
    public void addConsumer(Consumer consumer) throws BrokerException {
        try {
            this.authHandler.handle(ResourceAuthScope.QUEUES_CONSUME, ResourceType.QUEUE, consumer.getQueueName(), ResourceAction.CONSUME, this.subject);
            this.broker.addConsumer(consumer);
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
        catch (AuthNotFoundException e) {
            throw new BrokerAuthNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public boolean removeConsumer(Consumer consumer) {
        return this.broker.removeConsumer(consumer);
    }

    @Override
    public void declareExchange(String exchangeName, String type, boolean passive, boolean durable) throws BrokerException, ValidationException {
        try {
            if (!passive) {
                this.authHandler.handle(ResourceAuthScope.EXCHANGES_CREATE, this.subject);
            }
            this.broker.declareExchange(exchangeName, type, passive, durable);
            if (!passive) {
                this.authHandler.createAuthResource(ResourceType.EXCHANGE, exchangeName, durable, this.subject);
            }
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
    }

    @Override
    public void createExchange(String exchangeName, String type, boolean durable) throws BrokerException, ValidationException {
        try {
            this.authHandler.handle(ResourceAuthScope.EXCHANGES_CREATE, this.subject);
            this.broker.createExchange(exchangeName, type, durable);
            this.authHandler.createAuthResource(ResourceType.EXCHANGE, exchangeName, durable, this.subject);
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
    }

    @Override
    public boolean deleteExchange(String exchangeName, boolean ifUnused) throws BrokerException, ValidationException, ResourceNotFoundException {
        try {
            this.authHandler.handle(ResourceAuthScope.EXCHANGES_DELETE, ResourceType.EXCHANGE, exchangeName, ResourceAction.DELETE, this.subject);
            boolean success = this.broker.deleteExchange(exchangeName, ifUnused);
            if (success) {
                this.authHandler.deleteAuthResource(ResourceType.EXCHANGE, exchangeName);
            }
            return success;
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
        catch (AuthNotFoundException e) {
            throw new BrokerAuthNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public boolean createQueue(String queueName, boolean passive, boolean durable, boolean autoDelete) throws BrokerException, ValidationException {
        try {
            boolean succeed;
            if (!this.queueExists(queueName) && !passive) {
                this.authHandler.handle(ResourceAuthScope.QUEUES_CREATE, this.subject);
            }
            if (succeed = this.broker.createQueue(queueName, passive, durable, autoDelete)) {
                this.authHandler.createAuthResource(ResourceType.QUEUE, queueName, durable, this.subject);
            }
            return succeed;
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
    }

    @Override
    public int deleteQueue(String queueName, boolean ifUnused, boolean ifEmpty) throws BrokerException, ValidationException, ResourceNotFoundException {
        if (!this.queueExists(queueName)) {
            throw new ResourceNotFoundException("Queue [ " + queueName + " ] Not found");
        }
        try {
            this.authHandler.handle(ResourceAuthScope.QUEUES_DELETE, ResourceType.QUEUE, queueName, ResourceAction.DELETE, this.subject);
            int messageCount = this.broker.deleteQueue(queueName, ifUnused, ifEmpty);
            this.authHandler.deleteAuthResource(ResourceType.QUEUE, queueName);
            return messageCount;
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
        catch (AuthNotFoundException e) {
            throw new BrokerAuthNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public boolean queueExists(String queueName) {
        return this.broker.queueExists(queueName);
    }

    @Override
    public void bind(String queueName, String exchangeName, String routingKey, FieldTable arguments) throws BrokerException, ValidationException {
        this.broker.bind(queueName, exchangeName, routingKey, arguments);
    }

    @Override
    public void unbind(String queueName, String exchangeName, String routingKey) throws BrokerException, ValidationException {
        this.broker.unbind(queueName, exchangeName, routingKey);
    }

    @Override
    public void startMessageDelivery() {
        this.broker.startMessageDelivery();
    }

    @Override
    public int purgeQueue(String queueName) throws ResourceNotFoundException, ValidationException {
        return this.broker.purgeQueue(queueName);
    }

    @Override
    public void stopMessageDelivery() {
        this.broker.stopMessageDelivery();
    }

    @Override
    public void shutdown() {
        this.broker.shutdown();
    }

    @Override
    public void requeue(String queueName, Message message) throws BrokerException, ResourceNotFoundException {
        this.broker.requeue(queueName, message);
    }

    @Override
    public Collection<QueueHandler> getAllQueues() throws BrokerException {
        try {
            this.authHandler.handle(ResourceAuthScope.QUEUES_GET, this.subject);
            return this.broker.getAllQueues();
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
    }

    @Override
    public QueueHandler getQueue(String queueName) throws BrokerException, ResourceNotFoundException {
        if (!this.broker.queueExists(queueName)) {
            throw new ResourceNotFoundException("Queue [ " + queueName + " ] Not found");
        }
        try {
            this.authHandler.handle(ResourceAuthScope.QUEUES_GET, ResourceType.QUEUE, queueName, ResourceAction.GET, this.subject);
            return this.broker.getQueue(queueName);
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
        catch (AuthNotFoundException e) {
            throw new BrokerAuthNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public void moveToDlc(String queueName, Message message) throws BrokerException {
        this.broker.moveToDlc(queueName, message);
    }

    @Override
    public Collection<Exchange> getAllExchanges() throws BrokerException {
        try {
            this.authHandler.handle(ResourceAuthScope.SCOPES_GET, this.subject);
            return this.broker.getAllExchanges();
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, BindingSet> getAllBindingsForExchange(String exchangeName) throws ValidationException {
        return this.broker.getAllBindingsForExchange(exchangeName);
    }

    @Override
    public Exchange getExchange(String exchangeName) throws BrokerException {
        try {
            this.authHandler.handle(ResourceAuthScope.EXCHANGES_GET, ResourceType.EXCHANGE, exchangeName, ResourceAction.GET, this.subject);
            return this.broker.getExchange(exchangeName);
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
        catch (AuthNotFoundException e) {
            throw new BrokerAuthNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public BrokerTransaction newLocalTransaction() {
        return new SecureBrokerTransaction(this.broker.newLocalTransaction(), this.subject, this.authHandler);
    }

    @Override
    public BrokerTransaction newDistributedTransaction() {
        return new SecureBrokerTransaction(this.broker.newDistributedTransaction(), this.subject, this.authHandler);
    }

    @Override
    public Set<QueueHandler> restoreDtxPreparedMessages(Xid xid, Collection<Message> messages) throws BrokerException {
        return this.broker.restoreDtxPreparedMessages(xid, messages);
    }
}

