/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import java.util.UUID;

public class UniqueIdGenerator {
    private static final long REFERENCE_START = 1292976000000L;
    private final int instanceId = UUID.randomUUID().hashCode();
    private long previousTimestamp;
    private long previousId;
    private int offset;

    public synchronized long getNextId() {
        long ts = System.currentTimeMillis();
        this.offset = ts == this.previousTimestamp ? ++this.offset : 0;
        this.previousTimestamp = ts;
        long id = (ts - 1292976000000L) * 256L * 1024L + (long)this.instanceId * 1024L + (long)this.offset;
        if (this.previousId == id) {
            throw new RuntimeException("Duplicate ids detected. This should never happen");
        }
        this.previousId = id;
        return id;
    }
}

