/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.metrics;

import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.Meter;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.Timer;

public class DefaultBrokerMetricManager
implements BrokerMetricManager {
    private final Meter totalPublishedCounter;
    private final Counter totalEnqueueCounter;
    private final Meter totalAckCounter;
    private final Timer messageWriteTimer;
    private final Timer messageDeleteTimer;
    private final Timer messageReadTimer;

    public DefaultBrokerMetricManager(MetricService metrics) {
        this.totalPublishedCounter = metrics.meter(MetricService.name(Broker.class, (String[])new String[]{"node", "totalPublished"}), Level.INFO, new Level[0]);
        this.totalAckCounter = metrics.meter(MetricService.name(Broker.class, (String[])new String[]{"node", "totalAcknowledged"}), Level.INFO, new Level[0]);
        this.totalEnqueueCounter = metrics.counter(MetricService.name(Broker.class, (String[])new String[]{"node", "totalInMemoryMessages"}), Level.INFO, new Level[0]);
        this.messageWriteTimer = metrics.timer(MetricService.name(Broker.class, (String[])new String[]{"node", "messageWrite"}), Level.INFO);
        this.messageDeleteTimer = metrics.timer(MetricService.name(Broker.class, (String[])new String[]{"node", "messageDelete"}), Level.INFO);
        this.messageReadTimer = metrics.timer(MetricService.name(Broker.class, (String[])new String[]{"node", "messageRead"}), Level.INFO);
    }

    @Override
    public void markPublish() {
        this.totalPublishedCounter.mark();
    }

    @Override
    public void addInMemoryMessage() {
        this.totalEnqueueCounter.inc();
    }

    @Override
    public void removeInMemoryMessage() {
        this.totalEnqueueCounter.dec();
    }

    @Override
    public void markAcknowledge() {
        this.totalAckCounter.mark();
    }

    @Override
    public Timer.Context startMessageWriteTimer() {
        return this.messageWriteTimer.start();
    }

    @Override
    public Timer.Context startMessageDeleteTimer() {
        return this.messageDeleteTimer.start();
    }

    @Override
    public Timer.Context startMessageReadTimer() {
        return this.messageReadTimer.start();
    }
}

