/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.queue;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Queue;
import io.ballerina.messaging.broker.core.queue.QueueBuffer;
import io.ballerina.messaging.broker.core.queue.QueueBufferFactory;
import io.ballerina.messaging.broker.core.store.DbMessageStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbBackedQueueImpl
extends Queue {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbBackedQueueImpl.class);
    private final DbMessageStore dbMessageStore;
    private final QueueBuffer buffer;
    private final Map<Xid, List<Message>> pendingEnqueueMessages;
    private final Map<Xid, List<DetachableMessage>> pendingDequeueMessages;

    public DbBackedQueueImpl(String queueName, boolean autoDelete, DbMessageStore dbMessageStore, QueueBufferFactory queueBufferFactory) throws BrokerException {
        super(queueName, true, autoDelete);
        this.dbMessageStore = dbMessageStore;
        this.buffer = queueBufferFactory.createBuffer(dbMessageStore::fillMessageData);
        LOGGER.debug("Recovering messages for queue {}", (Object)queueName);
        Collection<Message> messages = dbMessageStore.readAllMessagesForQueue(queueName);
        this.pendingEnqueueMessages = new ConcurrentHashMap<Xid, List<Message>>();
        this.pendingDequeueMessages = new ConcurrentHashMap<Xid, List<DetachableMessage>>();
        this.buffer.addAllBareMessages(messages);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} messages recovered for queue {}", (Object)messages.size(), (Object)queueName);
        }
    }

    @Override
    public int capacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.buffer.getNumberOfUndeliveredMessages();
    }

    @Override
    public boolean enqueue(Message message) throws BrokerException {
        if (message.getMetadata().isPersistent()) {
            this.dbMessageStore.attach(this.getName(), message.getInternalId());
            this.buffer.add(message);
            return true;
        }
        return this.buffer.addIndelibleMessage(message);
    }

    @Override
    public void prepareEnqueue(Xid xid, Message message) throws BrokerException {
        if (message.getMetadata().isPersistent()) {
            this.dbMessageStore.attach(xid, this.getName(), message.getInternalId());
        }
        List messages = this.pendingEnqueueMessages.computeIfAbsent(xid, k -> new ArrayList());
        messages.add(message);
    }

    @Override
    public void commit(Xid xid) {
        List<Message> messages;
        List<DetachableMessage> dequeueMessages = this.pendingDequeueMessages.get(xid);
        if (Objects.nonNull(dequeueMessages)) {
            this.buffer.removeAll(dequeueMessages);
        }
        if (Objects.nonNull(messages = this.pendingEnqueueMessages.get(xid))) {
            this.buffer.addAll(messages);
        }
    }

    @Override
    public void rollback(Xid xid) {
        this.pendingDequeueMessages.remove(xid);
        List<Message> messages = this.pendingEnqueueMessages.remove(xid);
        if (Objects.nonNull(messages)) {
            messages.forEach(Message::release);
        }
    }

    @Override
    public Message dequeue() {
        return this.buffer.getFirstDeliverable();
    }

    @Override
    public void detach(DetachableMessage message) {
        this.dbMessageStore.detach(this.getName(), message);
        this.buffer.remove(message.getInternalId());
    }

    @Override
    public void prepareDetach(Xid xid, DetachableMessage detachableMessage) throws BrokerException {
        this.dbMessageStore.detach(xid, this.getName(), detachableMessage);
        List dequeueMessages = this.pendingDequeueMessages.computeIfAbsent(xid, k -> new ArrayList());
        dequeueMessages.add(detachableMessage);
    }

    @Override
    public int clear() {
        String queueName = this.getName();
        return this.buffer.clear(message -> {
            this.dbMessageStore.detach(queueName, message.getDetachableMessage());
            message.release();
        });
    }
}

