/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.queue;

import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Queue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.transaction.xa.Xid;

public class MemQueueImpl
extends Queue {
    private final int capacity;
    private final java.util.Queue<Message> queue;
    private final Map<Xid, List<Message>> pendingEnqueueMessages;

    public MemQueueImpl(String queueName, int capacity, boolean autoDelete) {
        this(queueName, false, capacity, autoDelete);
    }

    public MemQueueImpl(String queueName, boolean durable, int capacity, boolean autoDelete) {
        super(queueName, durable, autoDelete);
        this.capacity = capacity;
        this.queue = new LinkedBlockingDeque<Message>(capacity);
        this.pendingEnqueueMessages = new ConcurrentHashMap<Xid, List<Message>>();
    }

    public MemQueueImpl(String name, boolean autoDelete) {
        this(name, Integer.MAX_VALUE, autoDelete);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean enqueue(Message message) {
        return this.queue.offer(message);
    }

    @Override
    public void prepareEnqueue(Xid xid, Message message) {
        List transactionalMessages = this.pendingEnqueueMessages.computeIfAbsent(xid, k -> new ArrayList());
        transactionalMessages.add(message);
    }

    @Override
    public void commit(Xid xid) {
        List<Message> messages = this.pendingEnqueueMessages.get(xid);
        if (Objects.nonNull(messages)) {
            this.queue.addAll(messages);
        }
    }

    @Override
    public void rollback(Xid xid) {
        List<Message> messages = this.pendingEnqueueMessages.remove(xid);
        if (Objects.nonNull(messages)) {
            messages.forEach(Message::release);
        }
    }

    @Override
    public Message dequeue() {
        return this.queue.poll();
    }

    @Override
    public void detach(DetachableMessage detachableMessage) {
    }

    @Override
    public void prepareDetach(Xid xid, DetachableMessage detachableMessage) {
    }

    @Override
    public int clear() {
        int queueSize = this.queue.size();
        this.queue.forEach(Message::release);
        this.queue.clear();
        return queueSize;
    }
}

