/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class BindingCreateRequest {
    @Valid
    private String bindingPattern = null;
    @Valid
    private String exchangeName = null;
    @Valid
    private String filterExpression = null;

    public BindingCreateRequest bindingPattern(String bindingPattern) {
        this.bindingPattern = bindingPattern;
        return this;
    }

    @ApiModelProperty(required=true, value="Binding pattern that should routing keys")
    @JsonProperty(value="bindingPattern")
    @NotNull
    public String getBindingPattern() {
        return this.bindingPattern;
    }

    public void setBindingPattern(String bindingPattern) {
        this.bindingPattern = bindingPattern;
    }

    public BindingCreateRequest exchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the exchange to bind to")
    @JsonProperty(value="exchangeName")
    @NotNull
    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public BindingCreateRequest filterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    @ApiModelProperty(value="JMS selector relater message filter pattern")
    @JsonProperty(value="filterExpression")
    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindingCreateRequest bindingCreateRequest = (BindingCreateRequest)o;
        return Objects.equals(this.bindingPattern, bindingCreateRequest.bindingPattern) && Objects.equals(this.exchangeName, bindingCreateRequest.exchangeName) && Objects.equals(this.filterExpression, bindingCreateRequest.filterExpression);
    }

    public int hashCode() {
        return Objects.hash(this.bindingPattern, this.exchangeName, this.filterExpression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BindingCreateRequest {\n");
        sb.append("    bindingPattern: ").append(this.toIndentedString(this.bindingPattern)).append("\n");
        sb.append("    exchangeName: ").append(this.toIndentedString(this.exchangeName)).append("\n");
        sb.append("    filterExpression: ").append(this.toIndentedString(this.filterExpression)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

