/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class QueueCreateRequest {
    @Valid
    private String name = null;
    @Valid
    private Boolean durable = null;
    @Valid
    private Boolean autoDelete = null;

    public QueueCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the queue to be created")
    @JsonProperty(value="name")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueueCreateRequest durable(Boolean durable) {
        this.durable = durable;
        return this;
    }

    @ApiModelProperty(required=true, value="True if the queue is durable, false otherwise")
    @JsonProperty(value="durable")
    @NotNull
    public Boolean isDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public QueueCreateRequest autoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    @ApiModelProperty(required=true, value="deletes the queue when there are no consumers for the queue.")
    @JsonProperty(value="autoDelete")
    @NotNull
    public Boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueCreateRequest queueCreateRequest = (QueueCreateRequest)o;
        return Objects.equals(this.name, queueCreateRequest.name) && Objects.equals(this.durable, queueCreateRequest.durable) && Objects.equals(this.autoDelete, queueCreateRequest.autoDelete);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.durable, this.autoDelete);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueueCreateRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    durable: ").append(this.toIndentedString(this.durable)).append("\n");
        sb.append("    autoDelete: ").append(this.toIndentedString(this.autoDelete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

