/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.selector.generated;

import io.ballerina.messaging.broker.core.selector.BooleanExpression;
import io.ballerina.messaging.broker.core.selector.ConstantExpression;
import io.ballerina.messaging.broker.core.selector.EqualityExpression;
import io.ballerina.messaging.broker.core.selector.Expression;
import io.ballerina.messaging.broker.core.selector.JmsPropertyExpression;
import io.ballerina.messaging.broker.core.selector.generated.MessageFilterConstants;
import io.ballerina.messaging.broker.core.selector.generated.MessageFilterTokenManager;
import io.ballerina.messaging.broker.core.selector.generated.ParseException;
import io.ballerina.messaging.broker.core.selector.generated.SimpleCharStream;
import io.ballerina.messaging.broker.core.selector.generated.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class MessageFilter
implements MessageFilterConstants {
    public MessageFilterTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;

    public MessageFilter() {
        this(new StringReader(""));
    }

    public MessageFilter(String selectorString) {
        this(new StringReader(selectorString));
    }

    public BooleanExpression parse() throws Exception {
        return this.parseSelector();
    }

    public final BooleanExpression parseSelector() throws ParseException {
        BooleanExpression value = this.ComparisonExpression();
        this.jj_consume_token(0);
        return value;
    }

    public final BooleanExpression ComparisonExpression() throws ParseException {
        Expression left = this.identifier();
        this.jj_consume_token(19);
        Expression right = this.value();
        EqualityExpression value = new EqualityExpression(left, right);
        return value;
    }

    public final Expression identifier() throws ParseException {
        Token t = this.jj_consume_token(18);
        JmsPropertyExpression expr = new JmsPropertyExpression(t.image);
        return expr;
    }

    public final Expression value() throws ParseException {
        Expression expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                expr = this.stringLiteral();
                break;
            }
            case 16: {
                expr = this.numericLiteral();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    public final Expression stringLiteral() throws ParseException {
        Token t = this.jj_consume_token(17);
        String text = t.image;
        char[] charArray = new char[text.length() - 2];
        for (int i = 1; i < text.length() - 1; ++i) {
            charArray[i - 1] = text.charAt(i);
        }
        ConstantExpression expr = new ConstantExpression(new String(charArray));
        return expr;
    }

    public final Expression numericLiteral() throws ParseException {
        Token t = this.jj_consume_token(16);
        String text = t.image;
        ConstantExpression expr = ConstantExpression.createFromNumericInteger(text);
        return expr;
    }

    public MessageFilter(InputStream stream) {
        this(stream, null);
    }

    public MessageFilter(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MessageFilterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public MessageFilter(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MessageFilterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public MessageFilter(MessageFilterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(MessageFilterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

