/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import com.lmax.disruptor.EventHandler;
import io.ballerina.messaging.broker.common.DaoException;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.store.DbOperation;
import io.ballerina.messaging.broker.core.store.TransactionData;
import io.ballerina.messaging.broker.core.store.dao.MessageDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAccessHandler
implements EventHandler<DbOperation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAccessHandler.class);
    private final MessageDao messageDao;
    private final int maxBatchSize;
    private final TransactionData transactionData;
    private final List<DbOperation> transactionEvents;
    private final List<DbOperation> readEvents;

    public DbAccessHandler(MessageDao messageDao, int maxBatchSize) {
        this.messageDao = messageDao;
        this.maxBatchSize = maxBatchSize;
        this.transactionData = new TransactionData();
        this.readEvents = new ArrayList<DbOperation>(maxBatchSize);
        this.transactionEvents = new ArrayList<DbOperation>(maxBatchSize);
    }

    public void onEvent(DbOperation event, long sequence, boolean endOfBatch) throws Exception {
        while (!event.acquireForPersisting()) {
            LOGGER.debug("Waiting to acquire event to persist. Sequence {}", (Object)sequence);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} event added for id {} for sequence {}", new Object[]{event.getType(), event.getMessageId(), sequence});
        }
        switch (event.getType()) {
            case INSERT_MESSAGE: 
            case DELETE_MESSAGE: 
            case DETACH_MSG_FROM_QUEUE: {
                this.transactionEvents.add(event);
                break;
            }
            case READ_MSG_DATA: {
                this.readEvents.add(event);
                break;
            }
            case NO_OP: {
                break;
            }
            default: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.error("Unknown event type " + (Object)((Object)event.getType()));
            }
        }
        this.processTransactions(endOfBatch);
        this.processMessageReads(endOfBatch);
    }

    private void processTransactions(boolean endOfBatch) {
        if (this.isBatchReady(endOfBatch, this.transactionEvents)) {
            try {
                this.clusterTransactionEvents();
                this.messageDao.persist(this.transactionData);
            }
            catch (DaoException e) {
                this.transactionEvents.forEach(eventObject -> eventObject.setExceptionObject(e));
            }
            finally {
                this.transactionData.clear();
                this.transactionEvents.clear();
            }
        }
    }

    private void clusterTransactionEvents() {
        this.transactionEvents.forEach(txEvent -> {
            switch (txEvent.getType()) {
                case INSERT_MESSAGE: {
                    this.transactionData.addEnqueueMessage(txEvent.getMessage());
                    break;
                }
                case DELETE_MESSAGE: {
                    this.transactionData.addDeletableMessage(txEvent.getMessageId());
                    break;
                }
                case DETACH_MSG_FROM_QUEUE: {
                    this.transactionData.detach(txEvent.getQueueName(), txEvent.getMessageId());
                    break;
                }
                default: {
                    LOGGER.error("Invalid transaction event collected {}", (Object)txEvent.getType());
                }
            }
        });
    }

    private void processMessageReads(boolean endOfBatch) {
        if (this.isBatchReady(endOfBatch, this.readEvents)) {
            try {
                this.messageDao.read(this.getUniqueMessageList());
            }
            catch (DaoException e) {
                this.readEvents.forEach(eventObject -> eventObject.setExceptionObject(e));
            }
            finally {
                this.readEvents.clear();
            }
        }
    }

    private Map<Long, List<Message>> getUniqueMessageList() {
        HashMap<Long, List<Message>> readList = new HashMap<Long, List<Message>>(this.maxBatchSize);
        this.readEvents.forEach(action -> readList.computeIfAbsent(action.getBareMessage().getInternalId(), messageId -> new ArrayList()).add(action.getBareMessage()));
        return readList;
    }

    private boolean isBatchComplete(int collectionSize, boolean endOfBatch) {
        return collectionSize >= this.maxBatchSize || endOfBatch;
    }

    private boolean isBatchReady(boolean endOfBatch, Collection collection) {
        return !collection.isEmpty() && this.isBatchComplete(collection.size(), endOfBatch);
    }
}

