/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import com.lmax.disruptor.EventHandler;
import io.ballerina.messaging.broker.core.store.DbOperation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbEventMatcher
implements EventHandler<DbOperation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbEventMatcher.class);
    private final Map<Long, DbOperation> insertMap = new HashMap<Long, DbOperation>();
    private final Map<Long, List<DbOperation>> detachMap = new HashMap<Long, List<DbOperation>>();
    private final int maxBatchSize;
    private final Queue<Long> eventQueue;

    public DbEventMatcher(int ringBufferSize) {
        this.maxBatchSize = ringBufferSize;
        this.eventQueue = new ArrayDeque<Long>(ringBufferSize);
    }

    public void onEvent(DbOperation event, long sequence, boolean endOfBatch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} event with message id {} for sequence {}", new Object[]{event.getType(), event.getMessage(), sequence});
        }
        this.eventQueue.add(event.getMessageId());
        switch (event.getType()) {
            case INSERT_MESSAGE: {
                this.insertMap.put(event.getMessage().getInternalId(), event);
                break;
            }
            case DELETE_MESSAGE: {
                long internalId = event.getMessageId();
                this.removeMatchingInsertEvent(event, sequence, internalId);
                this.removeMatchingDetachEvents(internalId);
                break;
            }
            case DETACH_MSG_FROM_QUEUE: {
                this.detachMap.computeIfAbsent(event.getMessageId(), k -> new ArrayList()).add(event);
                break;
            }
            case READ_MSG_DATA: 
            case NO_OP: {
                break;
            }
            default: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.error("Unknown event type " + (Object)((Object)event.getType()));
            }
        }
        this.removeOldestEntryFromIndex();
        event.completeProcessing();
    }

    private void removeMatchingDetachEvents(long internalId) {
        List<DbOperation> detachRequestList = this.detachMap.remove(internalId);
        if (detachRequestList != null) {
            for (DbOperation detachRequest : detachRequestList) {
                if (!detachRequest.acquireForPersisting()) continue;
                detachRequest.clear();
                detachRequest.completeProcessing();
            }
        }
    }

    private void removeMatchingInsertEvent(DbOperation event, long sequence, long internalId) {
        DbOperation insertRequest = this.insertMap.remove(internalId);
        if (insertRequest != null && insertRequest.acquireToProcess()) {
            insertRequest.clear();
            event.clear();
            insertRequest.completeProcessing();
            LOGGER.debug("Matching insert event found and cleared for message id {} for sequence {}", (Object)internalId, (Object)sequence);
        }
    }

    private void removeOldestEntryFromIndex() {
        List<DbOperation> detachList;
        Long id;
        if (this.eventQueue.size() == this.maxBatchSize && this.insertMap.remove(id = this.eventQueue.poll()) == null && (detachList = this.detachMap.get(id)) != null && !detachList.isEmpty()) {
            detachList.remove(0);
            if (detachList.isEmpty()) {
                this.detachMap.remove(id);
            }
        }
    }
}

