/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import io.ballerina.messaging.broker.common.DaoException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.queue.QueueBuffer;
import io.ballerina.messaging.broker.core.store.DbAccessHandler;
import io.ballerina.messaging.broker.core.store.DbEventMatcher;
import io.ballerina.messaging.broker.core.store.DbOperation;
import io.ballerina.messaging.broker.core.store.DbStoreExceptionHandler;
import io.ballerina.messaging.broker.core.store.FinalEventHandler;
import io.ballerina.messaging.broker.core.store.MessageStore;
import io.ballerina.messaging.broker.core.store.TransactionData;
import io.ballerina.messaging.broker.core.store.dao.MessageDao;
import io.ballerina.messaging.broker.core.store.disruptor.SleepingBlockingWaitStrategy;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import javax.transaction.xa.Xid;

@ThreadSafe
public class DbMessageStore
extends MessageStore {
    private final Disruptor<DbOperation> disruptor;
    private static final EventTranslatorOneArg<DbOperation, Message> INSERT_MESSAGE = (event, sequence, message) -> event.insertMessage((Message)message);
    private static final EventTranslatorTwoArg<DbOperation, String, Long> DETACH_FROM_QUEUE = (event, sequence, queueName, messageId) -> event.detachFromQueue((String)queueName, (Long)messageId);
    private static final EventTranslatorOneArg<DbOperation, Long> DELETE_MESSAGE = (event, sequence, messageId) -> event.deleteMessage((long)messageId);
    private static final EventTranslatorTwoArg<DbOperation, QueueBuffer, Message> READ_MESSAGE_DATA = (event, sequence, queueBuffer, message) -> event.readMessageData((QueueBuffer)queueBuffer, (Message)message);
    private final MessageDao messageDao;

    DbMessageStore(MessageDao messageDao, int bufferSize, int maxDbBatchSize) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("DisruptorMessageStoreThread-%d").build();
        this.disruptor = new Disruptor((EventFactory)DbOperation.getFactory(), bufferSize, namedThreadFactory, ProducerType.MULTI, (WaitStrategy)new SleepingBlockingWaitStrategy());
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new DbStoreExceptionHandler());
        this.disruptor.handleEventsWith(new EventHandler[]{new DbEventMatcher(bufferSize)}).then(new EventHandler[]{new DbAccessHandler(messageDao, maxDbBatchSize)}).then(new EventHandler[]{new FinalEventHandler()});
        this.disruptor.start();
        this.messageDao = messageDao;
    }

    @Override
    void publishMessageToStore(Message message) {
        this.disruptor.publishEvent(INSERT_MESSAGE, (Object)message);
    }

    @Override
    void detachFromQueue(String queueName, long messageId) {
        this.disruptor.publishEvent(DETACH_FROM_QUEUE, (Object)queueName, (Object)messageId);
    }

    @Override
    void deleteMessage(long messageId) {
        this.disruptor.publishEvent(DELETE_MESSAGE, (Object)messageId);
    }

    @Override
    void commit(TransactionData transactionData) throws BrokerException {
        try {
            this.messageDao.persist(transactionData);
        }
        catch (DaoException e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    void commit(Xid xid, TransactionData transactionData) throws BrokerException {
        try {
            this.messageDao.commitPreparedData(xid, transactionData);
        }
        catch (DaoException e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    public void rollback(Xid xid) throws BrokerException {
        try {
            this.messageDao.rollbackPreparedData(xid);
        }
        catch (DaoException e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    public void fillMessageData(QueueBuffer queueBuffer, Message message) {
        this.disruptor.publishEvent(READ_MESSAGE_DATA, (Object)queueBuffer, (Object)message);
    }

    @Override
    public Collection<Message> readAllMessagesForQueue(String queueName) throws BrokerException {
        try {
            return this.messageDao.readAll(queueName);
        }
        catch (DaoException e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    public void prepare(Xid xid, TransactionData transactionData) throws BrokerException {
        try {
            this.messageDao.prepare(xid, transactionData);
        }
        catch (DaoException e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    public void retrieveStoredXids(Consumer<Xid> xidConsumer) throws BrokerException {
        try {
            this.messageDao.retrieveAllStoredXids(xidConsumer);
        }
        catch (DaoException e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<Message> recoverEnqueuedMessages(Xid xid) throws BrokerException {
        try {
            return this.messageDao.retrieveAllEnqueuedMessages(xid);
        }
        catch (DaoException e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }
}

