/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import com.lmax.disruptor.EventFactory;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.queue.QueueBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class DbOperation {
    private static final Factory factory = new Factory();
    private Throwable exceptionObject;
    private final AtomicInteger state;
    private static final int AVAILABLE = 0;
    private static final int PROCESSING = 1;
    private static final int PROCESSED = 2;
    private static final int PERSIST = 3;
    private DbOpType type = DbOpType.NO_OP;
    private String queueName;
    private long messageId;
    private Message message;
    private QueueBuffer queueBuffer;
    private Message bareMessage;

    private DbOperation() {
        this.state = new AtomicInteger(0);
    }

    public void insertMessage(Message message) {
        this.type = DbOpType.INSERT_MESSAGE;
        this.message = message;
        this.messageId = message.getInternalId();
    }

    public boolean acquireToProcess() {
        return this.state.compareAndSet(2, 1);
    }

    public void completeProcessing() {
        this.state.set(2);
    }

    public boolean acquireForPersisting() {
        return this.state.compareAndSet(2, 3);
    }

    public void deleteMessage(long messageId) {
        this.type = DbOpType.DELETE_MESSAGE;
        this.messageId = messageId;
    }

    public void detachFromQueue(String queueName, Long messageId) {
        this.type = DbOpType.DETACH_MSG_FROM_QUEUE;
        this.messageId = messageId;
        this.queueName = queueName;
    }

    public void readMessageData(QueueBuffer queueBuffer, Message message) {
        this.type = DbOpType.READ_MSG_DATA;
        this.bareMessage = message;
        this.queueBuffer = queueBuffer;
    }

    public void setExceptionObject(Throwable throwable) {
        this.exceptionObject = throwable;
    }

    public Throwable getExceptionObject() {
        return this.exceptionObject;
    }

    public Message getBareMessage() {
        return this.bareMessage;
    }

    public QueueBuffer getQueueBuffer() {
        return this.queueBuffer;
    }

    public DbOpType getType() {
        return this.type;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public Message getMessage() {
        return this.message;
    }

    public void clear() {
        if (Objects.nonNull(this.message)) {
            this.message.release();
            this.message = null;
        }
        this.bareMessage = null;
        this.queueBuffer = null;
        this.messageId = -1L;
        this.queueName = null;
        this.exceptionObject = null;
        this.type = DbOpType.NO_OP;
        this.state.set(0);
    }

    public static Factory getFactory() {
        return factory;
    }

    public static final class Factory
    implements EventFactory<DbOperation> {
        public DbOperation newInstance() {
            return new DbOperation();
        }
    }

    public static enum DbOpType {
        INSERT_MESSAGE,
        DETACH_MSG_FROM_QUEUE,
        DELETE_MESSAGE,
        READ_MSG_DATA,
        NO_OP;

    }
}

