/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import com.lmax.disruptor.EventHandler;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.queue.QueueBuffer;
import io.ballerina.messaging.broker.core.store.DbOperation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalEventHandler
implements EventHandler<DbOperation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinalEventHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(DbOperation event, long sequence, boolean endOfBatch) {
        Throwable exceptionObject = event.getExceptionObject();
        if (Objects.nonNull(exceptionObject)) {
            this.handleError(event, sequence, exceptionObject);
            return;
        }
        try {
            switch (event.getType()) {
                case READ_MSG_DATA: {
                    Message message = event.getBareMessage();
                    QueueBuffer queueBuffer = event.getQueueBuffer();
                    if (message.hasContent()) {
                        queueBuffer.markMessageFilled(message);
                        return;
                    } else {
                        LOGGER.error("Message {} was not read from the DB. Therefore dropping message", (Object)message.getInternalId());
                        queueBuffer.remove(message.getInternalId());
                        return;
                    }
                }
                case INSERT_MESSAGE: 
                case DELETE_MESSAGE: 
                case DETACH_MSG_FROM_QUEUE: 
                case NO_OP: {
                    return;
                }
                default: {
                    LOGGER.error("Unknown event type {}", (Object)event.getType());
                    return;
                }
            }
        }
        finally {
            event.clear();
        }
    }

    private void handleError(DbOperation event, long sequence, Throwable exceptionObject) {
        switch (event.getType()) {
            case READ_MSG_DATA: {
                Message message = event.getBareMessage();
                event.getQueueBuffer().markMessageFillFailed(message);
                LOGGER.warn("Message read failed for message {}", (Object)message.getInternalId());
                break;
            }
            case INSERT_MESSAGE: 
            case DELETE_MESSAGE: 
            case DETACH_MSG_FROM_QUEUE: {
                LOGGER.error("Error occurred while processing DB write event for sequence {} db operation {}", new Object[]{sequence, event, exceptionObject});
                break;
            }
            case NO_OP: {
                break;
            }
            default: {
                LOGGER.error("Unknown event type {}", (Object)event.getType(), (Object)exceptionObject);
            }
        }
    }
}

