/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store.dao.impl;

import io.ballerina.messaging.broker.common.BaseDao;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.core.Binding;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.store.dao.BindingDao;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

class BindingDaoImpl
extends BaseDao
implements BindingDao {
    BindingDaoImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void persist(String exchangeName, Binding binding) throws BrokerException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("INSERT INTO MB_BINDING (EXCHANGE_NAME, QUEUE_NAME, ROUTING_KEY, ARGUMENTS) VALUES(?, ?, ?, ?)");
            statement.setString(1, exchangeName);
            statement.setString(2, binding.getQueue().getName());
            statement.setString(3, binding.getBindingPattern());
            FieldTable arguments = binding.getArguments();
            byte[] bytes = new byte[(int)arguments.getSize()];
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
            byteBuf.resetWriterIndex();
            arguments.write(byteBuf);
            statement.setBytes(4, bytes);
            statement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while storing binding " + binding;
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement);
                throw throwable;
            }
        }
        this.close(connection, statement);
    }

    @Override
    public void delete(String queueName, String routingKey, String exchangeName) throws BrokerException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("DELETE FROM MB_BINDING WHERE EXCHANGE_NAME=? AND QUEUE_NAME=? AND ROUTING_KEY=?");
            statement.setString(1, exchangeName);
            statement.setString(2, queueName);
            statement.setString(3, routingKey);
            statement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while deleting the binding for queue " + queueName + " routing key " + routingKey;
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement);
                throw throwable;
            }
        }
        this.close(connection, statement);
    }

    @Override
    public void retrieveBindingsForExchange(String exchangeName, BindingDao.BindingCollector bindingCollector) throws BrokerException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("SELECT QUEUE_NAME, ROUTING_KEY, ARGUMENTS FROM MB_BINDING WHERE EXCHANGE_NAME=?");
            statement.setString(1, exchangeName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String queueName = resultSet.getString(1);
                String routingKey = resultSet.getString(2);
                byte[] arguments = resultSet.getBytes(3);
                FieldTable fieldTable = FieldTable.parse((ByteBuf)Unpooled.wrappedBuffer((byte[])arguments));
                bindingCollector.addBinding(queueName, routingKey, fieldTable);
            }
        }
        catch (Exception e) {
            try {
                String message = "Error occurred while retrieving bindings";
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, resultSet);
                throw throwable;
            }
        }
        this.close(connection, statement, resultSet);
    }
}

