/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store.dao.impl;

import io.ballerina.messaging.broker.core.ChunkConverter;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import io.ballerina.messaging.broker.core.store.dao.BindingDao;
import io.ballerina.messaging.broker.core.store.dao.ExchangeDao;
import io.ballerina.messaging.broker.core.store.dao.MessageDao;
import io.ballerina.messaging.broker.core.store.dao.QueueDao;
import io.ballerina.messaging.broker.core.store.dao.impl.BindingDaoImpl;
import io.ballerina.messaging.broker.core.store.dao.impl.DtxCrudOperationsDao;
import io.ballerina.messaging.broker.core.store.dao.impl.ExchangeDaoImpl;
import io.ballerina.messaging.broker.core.store.dao.impl.MessageCrudOperationsDao;
import io.ballerina.messaging.broker.core.store.dao.impl.MessageDaoImpl;
import io.ballerina.messaging.broker.core.store.dao.impl.QueueDaoImpl;
import javax.sql.DataSource;

public class DaoFactory {
    private final DataSource dataSource;
    private final BrokerMetricManager metricManager;
    private ChunkConverter chunkConverter;

    public DaoFactory(DataSource dataSource, BrokerMetricManager metricManager, BrokerCoreConfiguration configuration) {
        this.dataSource = dataSource;
        this.metricManager = metricManager;
        int maxPersistedChunkSize = Integer.parseInt(configuration.getMaxPersistedChunkSize());
        this.chunkConverter = new ChunkConverter(maxPersistedChunkSize);
    }

    public QueueDao createQueueDao() {
        return new QueueDaoImpl(this.dataSource);
    }

    public MessageDao createMessageDao() {
        return new MessageDaoImpl(new MessageCrudOperationsDao(this.dataSource, this.metricManager, this.chunkConverter), new DtxCrudOperationsDao(this.dataSource, this.chunkConverter));
    }

    public ExchangeDao createExchangeDao() {
        return new ExchangeDaoImpl(this.dataSource);
    }

    public BindingDao createBindingDao() {
        return new BindingDaoImpl(this.dataSource);
    }
}

