/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store.dao.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.ballerina.messaging.broker.common.BaseDao;
import io.ballerina.messaging.broker.common.DaoException;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.ChunkConverter;
import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.store.QueueDetachEventList;
import io.ballerina.messaging.broker.core.transaction.XidImpl;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import javax.transaction.xa.Xid;

public class DtxCrudOperationsDao
extends BaseDao {
    private ChunkConverter chunkConverter;

    DtxCrudOperationsDao(DataSource dataSource, ChunkConverter chunkConverter) {
        super(dataSource);
        this.chunkConverter = chunkConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long storeXid(Connection connection, Xid xid) throws SQLException {
        long internalXid = Broker.getNextMessageId();
        PreparedStatement insertStatement = null;
        try {
            insertStatement = connection.prepareStatement("INSERT INTO MB_DTX_XID (INTERNAL_XID, FORMAT_CODE, GLOBAL_ID, BRANCH_ID) VALUES (?,?,?,?)");
            insertStatement.setLong(1, internalXid);
            insertStatement.setInt(2, xid.getFormatId());
            insertStatement.setBytes(3, xid.getGlobalTransactionId());
            insertStatement.setBytes(4, xid.getBranchQualifier());
            insertStatement.executeUpdate();
        }
        finally {
            this.close(insertStatement);
        }
        return internalXid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareEnqueueMessages(Connection connection, long internalXid, Collection<Message> enqueueMessages) throws SQLException {
        PreparedStatement insertMetadataStatement = null;
        PreparedStatement insertContentStatement = null;
        PreparedStatement insertToQueueStatement = null;
        try {
            insertMetadataStatement = connection.prepareStatement("INSERT INTO MB_DTX_ENQUEUE_METADATA (INTERNAL_XID, MESSAGE_ID, EXCHANGE_NAME, ROUTING_KEY, CONTENT_LENGTH, MESSAGE_METADATA) VALUES (?,?,?,?,?,?)");
            insertContentStatement = connection.prepareStatement("INSERT INTO MB_DTX_ENQUEUE_CONTENT (INTERNAL_XID, MESSAGE_ID, CONTENT_OFFSET, MESSAGE_CONTENT) VALUES (?,?,?,?)");
            insertToQueueStatement = connection.prepareStatement("INSERT INTO MB_DTX_ENQUEUE_MAPPING (INTERNAL_XID, MESSAGE_ID, QUEUE_NAME) VALUES(?,?,?)");
            for (Message message : enqueueMessages) {
                this.prepareMetadataBatch(internalXid, insertMetadataStatement, message);
                this.prepareContentBatches(internalXid, insertContentStatement, message);
                this.prepareQueueAttachments(internalXid, insertToQueueStatement, message);
            }
            insertMetadataStatement.executeBatch();
            insertContentStatement.executeBatch();
            insertToQueueStatement.executeBatch();
        }
        catch (Throwable throwable) {
            this.close(insertMetadataStatement);
            this.close(insertContentStatement);
            this.close(insertToQueueStatement);
            throw throwable;
        }
        this.close(insertMetadataStatement);
        this.close(insertContentStatement);
        this.close(insertToQueueStatement);
    }

    private void prepareContentBatches(long internalXid, PreparedStatement insertContentStatement, Message message) throws SQLException {
        List<ContentChunk> contentChunks = message.getContentChunks();
        long contentLength = message.getMetadata().getContentLength();
        List<ContentChunk> convertedChunks = this.chunkConverter.convert(contentChunks, (int)contentLength);
        for (ContentChunk contentChunk : convertedChunks) {
            insertContentStatement.setLong(1, internalXid);
            insertContentStatement.setLong(2, message.getInternalId());
            insertContentStatement.setLong(3, contentChunk.getOffset());
            insertContentStatement.setBytes(4, contentChunk.getBytes());
            insertContentStatement.addBatch();
        }
    }

    private void prepareMetadataBatch(long internalXid, PreparedStatement insertMetadataStatement, Message message) throws SQLException {
        insertMetadataStatement.setLong(1, internalXid);
        insertMetadataStatement.setLong(2, message.getInternalId());
        insertMetadataStatement.setString(3, message.getMetadata().getExchangeName());
        insertMetadataStatement.setString(4, message.getMetadata().getRoutingKey());
        insertMetadataStatement.setLong(5, message.getMetadata().getContentLength());
        insertMetadataStatement.setBytes(6, message.getMetadata().getPropertiesAsBytes());
        insertMetadataStatement.addBatch();
    }

    private void prepareQueueAttachments(long internalXid, PreparedStatement insertToQueueStmt, Message message) throws SQLException {
        long id = message.getInternalId();
        for (String queueName : message.getAttachedDurableQueues()) {
            insertToQueueStmt.setLong(1, internalXid);
            insertToQueueStmt.setLong(2, id);
            insertToQueueStmt.setString(3, queueName);
            insertToQueueStmt.addBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareDetachMessages(Connection connection, long internalXid, Map<String, QueueDetachEventList> detachMessageMap) throws SQLException {
        PreparedStatement insertDetachEvent = null;
        try {
            insertDetachEvent = connection.prepareStatement("INSERT INTO MB_DTX_DEQUEUE_MAPPING (INTERNAL_XID, MESSAGE_ID, QUEUE_NAME) VALUES(?,?,?)");
            for (Map.Entry<String, QueueDetachEventList> detachEventEntry : detachMessageMap.entrySet()) {
                String queueName = detachEventEntry.getKey();
                QueueDetachEventList detachEvents = detachEventEntry.getValue();
                for (long messageId : detachEvents.getMessageIds()) {
                    insertDetachEvent.setLong(1, internalXid);
                    insertDetachEvent.setLong(2, messageId);
                    insertDetachEvent.setString(3, queueName);
                    insertDetachEvent.addBatch();
                }
            }
            insertDetachEvent.executeBatch();
        }
        finally {
            this.close(insertDetachEvent);
        }
    }

    public void copyEnqueueMessages(Connection connection, long internalXid) throws SQLException {
        this.copyFromPreparedTables(connection, internalXid, "INSERT INTO MB_METADATA (MESSAGE_ID, EXCHANGE_NAME, ROUTING_KEY, CONTENT_LENGTH, MESSAGE_METADATA) SELECT MESSAGE_ID, EXCHANGE_NAME, ROUTING_KEY, CONTENT_LENGTH, MESSAGE_METADATA FROM MB_DTX_ENQUEUE_METADATA WHERE INTERNAL_XID=?");
        this.copyFromPreparedTables(connection, internalXid, "INSERT INTO MB_CONTENT (MESSAGE_ID, CONTENT_OFFSET, MESSAGE_CONTENT) SELECT MESSAGE_ID, CONTENT_OFFSET, MESSAGE_CONTENT FROM MB_DTX_ENQUEUE_CONTENT WHERE INTERNAL_XID=?");
        this.copyFromPreparedTables(connection, internalXid, "INSERT INTO MB_QUEUE_MAPPING (MESSAGE_ID, QUEUE_NAME) SELECT MESSAGE_ID, QUEUE_NAME FROM MB_DTX_ENQUEUE_MAPPING WHERE INTERNAL_XID=?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void copyFromPreparedTables(Connection connection, long internalXid, String sqlString) throws SQLException {
        PreparedStatement copyStatement = null;
        try {
            copyStatement = connection.prepareStatement(sqlString);
            copyStatement.setLong(1, internalXid);
            copyStatement.execute();
        }
        finally {
            this.close(copyStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreparedData(Connection connection, long internalXid) throws SQLException {
        PreparedStatement deleteXidStatement = null;
        try {
            deleteXidStatement = connection.prepareStatement("DELETE FROM MB_DTX_XID WHERE INTERNAL_XID=?");
            deleteXidStatement.setLong(1, internalXid);
            deleteXidStatement.executeUpdate();
        }
        finally {
            this.close(deleteXidStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDequeueMessages(Connection connection, long internalXid) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO MB_QUEUE_MAPPING (MESSAGE_ID, QUEUE_NAME) SELECT MESSAGE_ID, QUEUE_NAME FROM MB_DTX_DEQUEUE_MAPPING WHERE INTERNAL_XID=?");
            preparedStatement.setLong(1, internalXid);
            preparedStatement.executeUpdate();
        }
        finally {
            this.close(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveAllXids(Connection connection, Consumer<XidImpl> xidConsumer) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT INTERNAL_XID, FORMAT_CODE, BRANCH_ID, GLOBAL_ID FROM MB_DTX_XID");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                XidImpl xid = new XidImpl(resultSet.getLong(1), resultSet.getInt(2), resultSet.getBytes(3), resultSet.getBytes(4));
                xidConsumer.accept(xid);
            }
        }
        catch (Throwable throwable) {
            this.close(resultSet);
            this.close(statement);
            throw throwable;
        }
        this.close(resultSet);
        this.close(statement);
    }

    public Collection<Message> retrieveEnqueuedMessages(Connection connection, long internalXid) throws DaoException {
        HashMap<Long, Message> enqueuedMessages = new HashMap<Long, Message>();
        try {
            this.populateMetadata(connection, internalXid, enqueuedMessages);
            this.populateContent(connection, internalXid, enqueuedMessages);
            this.updateQueueMapping(connection, internalXid, enqueuedMessages);
            return enqueuedMessages.values();
        }
        catch (Exception e) {
            throw new DaoException("Error occurred while retrieving enqueued dtx messages", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQueueMapping(Connection connection, long internalXid, HashMap<Long, Message> enqueuedMessages) throws SQLException {
        PreparedStatement queueMappingStmt = null;
        ResultSet resultSet = null;
        try {
            queueMappingStmt = connection.prepareStatement("SELECT MESSAGE_ID, QUEUE_NAME FROM MB_DTX_ENQUEUE_MAPPING WHERE INTERNAL_XID=?");
            queueMappingStmt.setLong(1, internalXid);
            resultSet = queueMappingStmt.executeQuery();
            while (resultSet.next()) {
                long messageId = resultSet.getLong("MESSAGE_ID");
                String queueName = resultSet.getString("QUEUE_NAME");
                Message message = enqueuedMessages.get(messageId);
                message.addAttachedDurableQueue(queueName);
            }
        }
        catch (Throwable throwable) {
            this.close(resultSet);
            this.close(queueMappingStmt);
            throw throwable;
        }
        this.close(resultSet);
        this.close(queueMappingStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateContent(Connection connection, long internalXid, HashMap<Long, Message> enqueuedMessages) throws SQLException {
        PreparedStatement retrieveContentStmt = null;
        ResultSet resultSet = null;
        try {
            retrieveContentStmt = connection.prepareStatement("SELECT MESSAGE_ID, CONTENT_OFFSET, MESSAGE_CONTENT FROM MB_DTX_ENQUEUE_CONTENT WHERE INTERNAL_XID=?");
            retrieveContentStmt.setLong(1, internalXid);
            resultSet = retrieveContentStmt.executeQuery();
            while (resultSet.next()) {
                long messageId = resultSet.getLong("MESSAGE_ID");
                Message message = enqueuedMessages.get(messageId);
                long offset = resultSet.getLong("CONTENT_OFFSET");
                byte[] contentBytes = resultSet.getBytes("MESSAGE_CONTENT");
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])contentBytes);
                message.addChunk(new ContentChunk(offset, byteBuf));
            }
        }
        catch (Throwable throwable) {
            this.close(resultSet);
            this.close(retrieveContentStmt);
            throw throwable;
        }
        this.close(resultSet);
        this.close(retrieveContentStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMetadata(Connection connection, long internalXid, HashMap<Long, Message> enqueuedMessages) throws Exception {
        PreparedStatement retrieveMetadataStmt = null;
        ResultSet resultSet = null;
        try {
            retrieveMetadataStmt = connection.prepareStatement("SELECT MESSAGE_ID, EXCHANGE_NAME, ROUTING_KEY, CONTENT_LENGTH, MESSAGE_METADATA FROM MB_DTX_ENQUEUE_METADATA WHERE INTERNAL_XID=?");
            retrieveMetadataStmt.setLong(1, internalXid);
            resultSet = retrieveMetadataStmt.executeQuery();
            while (resultSet.next()) {
                Metadata metadata = new Metadata(resultSet.getString("ROUTING_KEY"), resultSet.getString("EXCHANGE_NAME"), resultSet.getLong("CONTENT_LENGTH"), resultSet.getBytes("MESSAGE_METADATA"));
                Message message = new Message(resultSet.getLong("MESSAGE_ID"), metadata);
                enqueuedMessages.put(message.getInternalId(), message);
            }
        }
        catch (Throwable throwable) {
            this.close(resultSet);
            this.close(retrieveMetadataStmt);
            throw throwable;
        }
        this.close(resultSet);
        this.close(retrieveMetadataStmt);
    }
}

