/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store.dao.impl;

import io.ballerina.messaging.broker.common.DaoException;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.store.TransactionData;
import io.ballerina.messaging.broker.core.store.dao.MessageDao;
import io.ballerina.messaging.broker.core.store.dao.impl.DtxCrudOperationsDao;
import io.ballerina.messaging.broker.core.store.dao.impl.MessageCrudOperationsDao;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.transaction.xa.Xid;

class MessageDaoImpl
implements MessageDao {
    private static final long INVALID_XID = -1L;
    private final MessageCrudOperationsDao crudOperationsDao;
    private final DtxCrudOperationsDao dtxCrudOperationsDao;
    private final Map<Xid, Long> xidToInternalIdMap;

    MessageDaoImpl(MessageCrudOperationsDao crudOperationsDao, DtxCrudOperationsDao dtxCrudOperationsDao) {
        this.crudOperationsDao = crudOperationsDao;
        this.dtxCrudOperationsDao = dtxCrudOperationsDao;
        this.xidToInternalIdMap = new ConcurrentHashMap<Xid, Long>();
    }

    @Override
    public void persist(TransactionData transactionData) throws DaoException {
        this.crudOperationsDao.transaction(connection -> {
            this.crudOperationsDao.storeMessages((Connection)connection, transactionData.getEnqueueMessages());
            this.crudOperationsDao.detachFromQueue((Connection)connection, transactionData.getDetachMessageMap());
            this.crudOperationsDao.delete((Connection)connection, transactionData.getDeletableMessage());
        });
    }

    @Override
    public Collection<Message> readAll(String queueName) throws DaoException {
        return (Collection)this.crudOperationsDao.selectAndGetOperation(connection -> this.crudOperationsDao.readAll((Connection)connection, queueName));
    }

    @Override
    public void read(Map<Long, List<Message>> readList) throws DaoException {
        this.crudOperationsDao.selectOperation(connection -> this.crudOperationsDao.read((Connection)connection, readList));
    }

    @Override
    public void prepare(Xid xid, TransactionData transactionData) throws DaoException {
        this.dtxCrudOperationsDao.transaction(connection -> {
            long internalXid = this.dtxCrudOperationsDao.storeXid((Connection)connection, xid);
            this.dtxCrudOperationsDao.prepareEnqueueMessages((Connection)connection, internalXid, transactionData.getEnqueueMessages());
            this.dtxCrudOperationsDao.prepareDetachMessages((Connection)connection, internalXid, transactionData.getDetachMessageMap());
            this.crudOperationsDao.detachFromQueue((Connection)connection, transactionData.getDetachMessageMap());
            this.xidToInternalIdMap.put(xid, internalXid);
        });
    }

    @Override
    public void commitPreparedData(Xid xid, TransactionData transactionData) throws DaoException {
        this.dtxCrudOperationsDao.transaction(connection -> {
            long internalXid = this.getInternalXid(xid);
            this.dtxCrudOperationsDao.copyEnqueueMessages((Connection)connection, internalXid);
            this.crudOperationsDao.delete((Connection)connection, transactionData.getDeletableMessage());
            this.dtxCrudOperationsDao.removePreparedData((Connection)connection, internalXid);
        });
        this.xidToInternalIdMap.remove(xid);
    }

    @Override
    public void rollbackPreparedData(Xid xid) throws DaoException {
        this.dtxCrudOperationsDao.transaction(connection -> {
            long internalXid = this.getInternalXid(xid);
            if (internalXid != -1L) {
                this.dtxCrudOperationsDao.restoreDequeueMessages((Connection)connection, internalXid);
                this.dtxCrudOperationsDao.removePreparedData((Connection)connection, internalXid);
            }
        });
        this.xidToInternalIdMap.remove(xid);
    }

    @Override
    public void retrieveAllStoredXids(Consumer<Xid> xidConsumer) throws DaoException {
        this.dtxCrudOperationsDao.transaction(connection -> this.dtxCrudOperationsDao.retrieveAllXids((Connection)connection, xid -> {
            this.xidToInternalIdMap.put((Xid)xid, xid.getInternalXid());
            xidConsumer.accept((Xid)xid);
        }));
    }

    @Override
    public Collection<Message> retrieveAllEnqueuedMessages(Xid xid) throws DaoException {
        return (Collection)this.dtxCrudOperationsDao.selectAndGetOperation(connection -> this.dtxCrudOperationsDao.retrieveEnqueuedMessages((Connection)connection, this.getInternalXid(xid)));
    }

    private long getInternalXid(Xid xid) {
        Long id = this.xidToInternalIdMap.get(xid);
        if (Objects.isNull(id)) {
            return -1L;
        }
        return id;
    }
}

