/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store.dao.impl;

import io.ballerina.messaging.broker.common.BaseDao;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Queue;
import io.ballerina.messaging.broker.core.store.dao.QueueDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

class QueueDaoImpl
extends BaseDao
implements QueueDao {
    QueueDaoImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void persist(Queue queue) throws BrokerException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("INSERT INTO MB_QUEUE_METADATA (QUEUE_NAME, QUEUE_ARGUMENTS) VALUES(?,?)");
            statement.setString(1, queue.getName());
            statement.setBytes(2, new byte[4]);
            statement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while storing queue " + queue;
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement);
                throw throwable;
            }
        }
        this.close(connection, statement);
    }

    @Override
    public void delete(Queue queue) throws BrokerException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("DELETE FROM MB_QUEUE_METADATA WHERE QUEUE_NAME=?");
            statement.setString(1, queue.getName());
            statement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while deleting queue " + queue;
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement);
                throw throwable;
            }
        }
        this.close(connection, statement);
    }

    @Override
    public void retrieveAll(QueueDao.QueueCollector queueNameConsumer) throws BrokerException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT QUEUE_NAME, QUEUE_ARGUMENTS FROM MB_QUEUE_METADATA");
            while (resultSet.next()) {
                String name = resultSet.getString(1);
                queueNameConsumer.addQueue(name);
            }
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while retrieving all the queues";
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, resultSet);
                throw throwable;
            }
        }
        this.close(connection, statement, resultSet);
    }
}

