/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.task;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.ballerina.messaging.broker.core.task.Task;
import io.ballerina.messaging.broker.core.task.TaskExceptionHandler;
import io.ballerina.messaging.broker.core.task.TaskHolder;
import io.ballerina.messaging.broker.core.task.TaskProcessor;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskExecutorService<T extends Task> {
    private static Logger log = LoggerFactory.getLogger(TaskExecutorService.class);
    private final DelayQueue<TaskHolder> taskHolderDelayQueue;
    private final Map<String, TaskHolder<T>> taskHolderRegistry;
    private final int workerCount;
    private final ExecutorService taskExecutorPool;
    private final Queue<TaskProcessor> taskProcessorQueue;
    private final ExecutorService taskUpdateExecutorService;
    private TaskExceptionHandler taskExceptionHandler;
    private long idleTaskDelayMillis;

    public TaskExecutorService(int workerCount, long idleTaskDelayMillis, ThreadFactory threadFactory) {
        this.taskExecutorPool = Executors.newFixedThreadPool(workerCount, threadFactory);
        this.workerCount = workerCount;
        this.taskProcessorQueue = new ArrayDeque<TaskProcessor>(workerCount);
        this.taskUpdateExecutorService = Executors.newSingleThreadExecutor(threadFactory);
        this.taskExceptionHandler = new DefaultExceptionHandler();
        this.taskHolderDelayQueue = new DelayQueue();
        this.taskHolderRegistry = new ConcurrentHashMap<String, TaskHolder<T>>();
        this.idleTaskDelayMillis = idleTaskDelayMillis;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Return future ignored since the execution needs be done asynchronously.")
    public void add(T task) {
        if (log.isDebugEnabled()) {
            log.debug("Task add request " + ((Task)task).getId());
        }
        this.taskUpdateExecutorService.submit(new AddRequest(this, task));
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Return future ignored since the execution needs be done asynchronously.")
    public void remove(String id) {
        if (log.isDebugEnabled()) {
            log.debug("Task remove request. Task id " + id);
        }
        this.taskUpdateExecutorService.submit(new RemoveRequest(id));
    }

    public T getTask(String taskId) {
        TaskHolder<T> taskHolder = this.taskHolderRegistry.get(taskId);
        if (taskHolder != null) {
            return taskHolder.getTask();
        }
        return null;
    }

    public synchronized void stop() {
        log.info("Stopping task manager. Task count {}", (Object)this.taskHolderDelayQueue.size());
        for (TaskProcessor taskProcessor : this.taskProcessorQueue) {
            taskProcessor.deactivate();
        }
        this.taskProcessorQueue.clear();
    }

    public void shutdown() {
        this.stop();
        this.taskExecutorPool.shutdownNow();
        try {
            int maxTerminationAwaitTime = 1;
            boolean terminationSuccessful = this.taskExecutorPool.awaitTermination(maxTerminationAwaitTime, TimeUnit.MINUTES);
            if (!terminationSuccessful) {
                log.error("Could not stop task manager.");
            }
        }
        catch (InterruptedException e) {
            log.error("Task manager shutdown process was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Return future ignored since the execution needs be done asynchronously.")
    public synchronized void start() {
        log.info("Starting task manager. Task count {}", (Object)this.taskHolderDelayQueue.size());
        for (int i = 0; i < this.workerCount; ++i) {
            TaskProcessor taskProcessor = new TaskProcessor(this.taskHolderDelayQueue, this.taskExceptionHandler, this.idleTaskDelayMillis);
            this.taskProcessorQueue.add(taskProcessor);
            this.taskExecutorPool.submit(taskProcessor);
        }
    }

    public synchronized void setExceptionHandler(TaskExceptionHandler exceptionHandler) {
        this.taskExceptionHandler = exceptionHandler;
    }

    private static class DefaultExceptionHandler
    implements TaskExceptionHandler {
        private static Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);

        private DefaultExceptionHandler() {
        }

        @Override
        public void handleException(Throwable throwable, String id) {
            log.error("Error occurred while processing task. Task id {}", (Object)id, (Object)throwable);
        }
    }

    private class RemoveRequest
    implements Runnable {
        private String id;

        RemoveRequest(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                TaskHolder taskHolder = (TaskHolder)TaskExecutorService.this.taskHolderRegistry.remove(this.id);
                taskHolder.disableProcessing();
                if (log.isDebugEnabled()) {
                    log.debug("Task removed. ID {} Total tasks {}", (Object)taskHolder.getId(), (Object)TaskExecutorService.this.taskHolderDelayQueue.size());
                }
            }
            catch (Throwable e) {
                log.error("Error occurred while removing task. Task id {}", (Object)this.id, (Object)e);
            }
        }
    }

    private static class AddRequest
    implements Runnable {
        private T task;
        final /* synthetic */ TaskExecutorService this$0;

        AddRequest(T task) {
            this.this$0 = var1_1;
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (this.this$0.taskHolderRegistry.containsKey(((Task)this.task).getId())) {
                    return;
                }
                TaskHolder taskHolder = new TaskHolder(this.task);
                ((Task)this.task).onAdd();
                this.this$0.taskHolderRegistry.put(((Task)this.task).getId(), taskHolder);
                this.this$0.taskHolderDelayQueue.add(taskHolder);
                if (log.isDebugEnabled()) {
                    log.debug("Task added. ID {} Total Tasks {}", (Object)((Task)this.task).getId(), (Object)this.this$0.taskHolderDelayQueue.size());
                }
            }
            catch (Throwable e) {
                log.error("Error occurred while adding Task {}", this.task, (Object)e);
            }
        }
    }
}

