/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;

public class AutoCommitTransaction
implements BrokerTransaction {
    private final Broker broker;

    public AutoCommitTransaction(Broker broker) {
        this.broker = broker;
    }

    @Override
    public void dequeue(String queue, DetachableMessage detachableMessage) throws BrokerException {
        this.broker.acknowledge(queue, detachableMessage);
    }

    @Override
    public void enqueue(Message message) throws BrokerException {
        this.broker.publish(message);
    }

    @Override
    public void commit() throws ValidationException {
        throw new ValidationException("tx.commit called on non-transactional channel");
    }

    @Override
    public void rollback() throws ValidationException {
        throw new ValidationException("tx.rollback called on non-transactional channel");
    }

    @Override
    public void addPostTransactionAction(BrokerTransaction.Action postTransactionAction) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public void start(Xid xid, int sessionId, boolean join, boolean resume) throws ValidationException {
        throw new ValidationException("dtx.start called on non-transactional channel");
    }

    @Override
    public void end(Xid xid, int sessionId, boolean fail, boolean suspend) throws ValidationException {
        throw new ValidationException("dtx.end called on non-transactional channel");
    }

    @Override
    public void prepare(Xid xid) throws ValidationException {
        throw new ValidationException("dtx.prepare called on non-transactional channel");
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws ValidationException {
        throw new ValidationException("dtx.commit called on non-transactional channel");
    }

    @Override
    public void rollback(Xid xid) throws ValidationException {
        throw new ValidationException("dtx.rollback called on non-transactional channel");
    }

    @Override
    public void forget(Xid xid) throws ValidationException {
        throw new ValidationException("dtx.forget called on non-transactional channel");
    }

    @Override
    public void setTimeout(Xid xid, long timeout, TimeUnit timeUnit) throws ValidationException {
        throw new ValidationException("dtx.set-timeout called on non-transactional channel");
    }

    @Override
    public boolean inTransactionBlock() {
        return false;
    }
}

