/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.store.MessageStore;
import io.ballerina.messaging.broker.core.transaction.BranchFactory;
import io.ballerina.messaging.broker.core.transaction.DistributedTransaction;
import io.ballerina.messaging.broker.core.transaction.LocalTransaction;
import io.ballerina.messaging.broker.core.transaction.Registry;

public class BrokerTransactionFactory {
    private final BranchFactory branchFactory;
    private final Registry registry;

    public BrokerTransactionFactory(Broker broker, MessageStore messageStore) {
        this.branchFactory = new BranchFactory(broker, messageStore);
        this.registry = new Registry(this.branchFactory);
    }

    public void syncWithMessageStore(MessageStore messageStore) throws BrokerException {
        this.registry.syncWithMessageStore(messageStore);
    }

    public LocalTransaction newLocalTransaction() {
        return new LocalTransaction(this.registry, this.branchFactory);
    }

    public DistributedTransaction newDistributedTransaction() {
        return new DistributedTransaction(this.branchFactory, this.registry);
    }
}

