/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.transaction.Branch;
import io.ballerina.messaging.broker.core.transaction.BranchFactory;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import io.ballerina.messaging.broker.core.transaction.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransaction
implements BrokerTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTransaction.class);
    private final List<BrokerTransaction.Action> postTransactionActions = new ArrayList<BrokerTransaction.Action>();
    private final Registry transactionRegistry;
    private Branch branch;
    private boolean preConditionFailed;
    private StringBuilder errorMessageBuilder;
    private final BranchFactory branchFactory;

    LocalTransaction(Registry registry, BranchFactory branchFactory) {
        this.transactionRegistry = registry;
        this.preConditionFailed = false;
        this.branchFactory = branchFactory;
        this.errorMessageBuilder = new StringBuilder();
        this.branch = null;
    }

    @Override
    public void dequeue(String queueName, DetachableMessage detachableMessage) {
        try {
            this.createBranchIfNeeded();
            this.branch.dequeue(queueName, detachableMessage);
        }
        catch (BrokerException e) {
            this.preConditionFailed = true;
            this.errorMessageBuilder.append(e.getMessage()).append('\n');
        }
    }

    @Override
    public void enqueue(Message message) {
        try {
            this.createBranchIfNeeded();
            this.branch.enqueue(message);
        }
        catch (BrokerException e) {
            this.preConditionFailed = true;
            this.errorMessageBuilder.append(e.getMessage()).append('\n');
        }
    }

    @Override
    public void commit() throws BrokerException, ValidationException {
        if (this.preConditionFailed) {
            throw new ValidationException("Pre conditions failed for commit. Errors " + this.errorMessageBuilder.toString());
        }
        if (Objects.isNull(this.branch)) {
            LOGGER.debug("Nothing to commit. Transaction branch is null");
            return;
        }
        this.branch.commit(true);
        this.doPostCommit();
        this.clear();
    }

    @Override
    public void rollback() {
        if (Objects.isNull(this.branch)) {
            LOGGER.debug("Nothing to commit. Transaction branch is null");
            return;
        }
        this.branch.rollback();
        this.doOnRollback();
        this.clear();
    }

    @Override
    public void onClose() {
        this.rollback();
    }

    @Override
    public void start(Xid xid, int sessionId, boolean join, boolean resume) throws ValidationException {
        throw new ValidationException("dtx.start called on local-transactional channel");
    }

    @Override
    public void end(Xid xid, int sessionId, boolean fail, boolean suspend) throws ValidationException {
        throw new ValidationException("dtx.end called on local-transactional channel");
    }

    @Override
    public void prepare(Xid xid) throws ValidationException {
        throw new ValidationException("dtx.prepare called on local-transactional channel");
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws ValidationException {
        throw new ValidationException("dtx.commit called on local-transactional channel");
    }

    @Override
    public void rollback(Xid xid) throws ValidationException {
        throw new ValidationException("dtx.rollback called on local-transactional channel");
    }

    @Override
    public void forget(Xid xid) throws ValidationException {
        throw new ValidationException("dtx.forget called on local-transactional channel");
    }

    @Override
    public void setTimeout(Xid xid, long timeout, TimeUnit timeUnit) throws ValidationException {
        throw new ValidationException("dtx.set-timeout called on local-transactional channel");
    }

    @Override
    public boolean inTransactionBlock() {
        return true;
    }

    @Override
    public void addPostTransactionAction(BrokerTransaction.Action postTransactionAction) {
        this.postTransactionActions.add(postTransactionAction);
    }

    private void doPostCommit() {
        for (BrokerTransaction.Action postTransactionAction : this.postTransactionActions) {
            postTransactionAction.postCommit();
        }
    }

    private void clear() {
        this.preConditionFailed = false;
        this.errorMessageBuilder.setLength(0);
        this.transactionRegistry.unregister(this.branch.getXid());
        this.branch = null;
    }

    private void doOnRollback() {
        for (BrokerTransaction.Action postTransactionAction : this.postTransactionActions) {
            postTransactionAction.onRollback();
        }
    }

    private void createBranchIfNeeded() throws BrokerException {
        if (Objects.nonNull(this.branch)) {
            return;
        }
        try {
            this.branch = this.branchFactory.createBranch();
            this.transactionRegistry.register(this.branch);
        }
        catch (ValidationException e) {
            throw new BrokerException("Error occurred while registering branch.", e);
        }
    }
}

