/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid {
    private final byte[] branchQualifier;
    private final int formatId;
    private final byte[] globalTransactionId;
    private long internalXid;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP2"}, justification="Data holder of global transaction identifier and branch qualifier")
    public XidImpl(int formatId, byte[] branchQualifier, byte[] globalTransactionId) {
        this.branchQualifier = branchQualifier;
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
    }

    public XidImpl(long internalXid, int formatId, byte[] branchQualifier, byte[] globalTransactionId) {
        this(formatId, branchQualifier, globalTransactionId);
        this.internalXid = internalXid;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Data holder of global transaction identifier")
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Data holder of branch qualifier")
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Xid) {
            return Arrays.equals(this.branchQualifier, ((Xid)obj).getBranchQualifier()) && Arrays.equals(this.globalTransactionId, ((Xid)obj).getGlobalTransactionId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.branchQualifier), Arrays.hashCode(this.globalTransactionId));
    }

    public String toString() {
        return "XidImpl{formatId=" + this.formatId + ", branchQualifier=" + new String(this.branchQualifier, StandardCharsets.UTF_8) + ", globalTransactionId=" + new String(this.globalTransactionId, StandardCharsets.UTF_8) + '}';
    }

    public long getInternalXid() {
        return this.internalXid;
    }
}

