/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.coordination;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.ballerina.messaging.broker.coordination.HaListener;
import io.ballerina.messaging.broker.coordination.HaStrategy;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHaStrategy
implements HaStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractHaStrategy.class);
    private TreeSet<PrioritizedHaListener> prioritizedHaListeners = new TreeSet();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void registerListener(HaListener haListener, int priority) {
        this.prioritizedHaListeners.add(new PrioritizedHaListener(haListener, priority));
    }

    @Override
    public void unregisterListener(HaListener haListener) {
        Iterator<PrioritizedHaListener> prioritizedHaListenerIterator = this.prioritizedHaListeners.iterator();
        while (prioritizedHaListenerIterator.hasNext()) {
            PrioritizedHaListener prioritizedHaListener = prioritizedHaListenerIterator.next();
            if (!prioritizedHaListener.haListener.equals(haListener)) continue;
            prioritizedHaListenerIterator.remove();
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Return future is ignored since the execution needs be done asynchronously.")
    protected void notifyBecameActiveNode() {
        LOGGER.info("Current node became the ACTIVE node");
        for (PrioritizedHaListener prioritizedHaListener : this.prioritizedHaListeners) {
            this.executorService.submit(prioritizedHaListener.haListener::activate);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Return future is ignored since the execution needs be done asynchronously.")
    protected void notifyBecamePassiveNode() {
        LOGGER.info("Current node became a PASSIVE node");
        Iterator<PrioritizedHaListener> prioritizedHaListenerIterator = this.prioritizedHaListeners.descendingIterator();
        while (prioritizedHaListenerIterator.hasNext()) {
            this.executorService.submit(prioritizedHaListenerIterator.next().haListener::deactivate);
        }
    }

    @Override
    public void stop() {
        this.executorService.shutdown();
    }

    private static class PrioritizedHaListener
    implements Comparable<PrioritizedHaListener> {
        private HaListener haListener;
        private int priority;

        PrioritizedHaListener(HaListener haListener, int priority) {
            this.haListener = haListener;
            this.priority = priority;
        }

        @Override
        public int compareTo(@Nonnull PrioritizedHaListener prioritizedHaListener) {
            return this.priority - prioritizedHaListener.priority;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PrioritizedHaListener)) {
                return false;
            }
            PrioritizedHaListener prioritizedHaListener = (PrioritizedHaListener)object;
            return this.haListener.equals(prioritizedHaListener.haListener);
        }

        public int hashCode() {
            return this.haListener.hashCode();
        }
    }
}

