/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.protobuf.cmd;

import com.google.protobuf.DescriptorProtos;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.ballerinalang.net.grpc.proto.ServiceProtoConstants;
import org.ballerinalang.protobuf.BalGenerationConstants;
import org.ballerinalang.protobuf.exception.CodeGeneratorException;
import org.ballerinalang.protobuf.utils.BalFileGenerationUtils;
import org.ballerinalang.protobuf.utils.ProtocCommandBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorsGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DescriptorsGenerator.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Set<byte[]> generateDependentDescriptor(String exePath, String rootProtoPath, String rootDescriptorPath) throws CodeGeneratorException {
        HashSet<byte[]> dependentDescSet = new HashSet<byte[]>();
        File tempDir = new File(ServiceProtoConstants.TMP_DIRECTORY_PATH);
        File initialFile = new File(rootDescriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet descSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)targetStream);
            for (String dependentFilePath : descSet.getFile(0).getDependencyList()) {
                String protoPath;
                String protoFolderPath;
                String descFilename;
                Path protoFilePath;
                if (BalFileGenerationUtils.isWindows()) {
                    dependentFilePath = dependentFilePath.replaceAll("/", "\\\\");
                }
                if ((protoFilePath = Paths.get(dependentFilePath, new String[0]).getFileName()) == null) {
                    throw new CodeGeneratorException("Error occurred while reading proto descriptor. Dependent filepath is not defined properly. Filepath: " + dependentFilePath);
                }
                String protoFilename = protoFilePath.toString();
                String string = descFilename = protoFilename.endsWith(".proto") ? protoFilename.replace(".proto", ".desc") : null;
                if (descFilename == null) {
                    throw new CodeGeneratorException("Error occurred while reading proto descriptor. Dependent filepath is not defined properly. Filepath: " + dependentFilePath);
                }
                String relativeDescFilepath = BalGenerationConstants.META_DEPENDENCY_LOCATION + descFilename;
                File dependentDescFile = new File(tempDir, relativeDescFilepath);
                boolean isDirectoryCreated = dependentDescFile.getParentFile().mkdirs();
                if (!isDirectoryCreated) {
                    LOG.debug("Parent directories didn't create for the file '" + relativeDescFilepath);
                }
                if (!dependentFilePath.contains(BalGenerationConstants.GOOGLE_STANDARD_LIB)) {
                    protoFolderPath = BalFileGenerationUtils.resolveProtoFolderPath(rootProtoPath);
                    protoPath = new File(protoFolderPath, dependentFilePath).getAbsolutePath();
                } else {
                    protoPath = new File(tempDir, dependentFilePath).getAbsolutePath();
                    protoFolderPath = tempDir.getAbsolutePath();
                }
                String command = new ProtocCommandBuilder(exePath, protoPath, protoFolderPath, dependentDescFile.getAbsolutePath()).build();
                BalFileGenerationUtils.generateDescriptor(command);
                File childFile = new File(tempDir, relativeDescFilepath);
                try {
                    FileInputStream childStream = new FileInputStream(childFile);
                    Throwable throwable = null;
                    try {
                        byte[] dependentDesc;
                        DescriptorProtos.FileDescriptorSet childDescSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)childStream);
                        if (childDescSet.getFile(0).getDependencyCount() != 0) {
                            Set<byte[]> childList = DescriptorsGenerator.generateDependentDescriptor(exePath, rootProtoPath, childFile.getAbsolutePath());
                            dependentDescSet.addAll(childList);
                        }
                        if ((dependentDesc = childDescSet.getFile(0).toByteArray()).length == 0) {
                            throw new CodeGeneratorException("Error occurred at generating dependent proto descriptor for dependent proto '" + relativeDescFilepath + "'.");
                        }
                        dependentDescSet.add(dependentDesc);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (childStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)childStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)childStream).close();
                    }
                }
                catch (IOException e) {
                    throw new CodeGeneratorException("Error extracting dependent bal.", e);
                    return dependentDescSet;
                }
            }
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error parsing descriptor file " + initialFile, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] generateRootDescriptor(String exePath, String protoPath, String descriptorPath) throws CodeGeneratorException {
        String command = new ProtocCommandBuilder(exePath, protoPath, BalFileGenerationUtils.resolveProtoFolderPath(protoPath), descriptorPath).build();
        BalFileGenerationUtils.generateDescriptor(command);
        File initialFile = new File(descriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)targetStream);
            if (set.getFileList().size() <= 0) return new byte[0];
            byte[] byArray = set.getFile(0).toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error reading generated descriptor file '" + descriptorPath + "'.", e);
        }
    }
}

