/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.protobuf.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.ballerinalang.protobuf.BalGenerationConstants;
import org.ballerinalang.protobuf.exception.CodeGeneratorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalFileGenerationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BalFileGenerationUtils.class);

    public static void generateDescriptor(String command) throws CodeGeneratorException {
        Process process;
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (isWindows) {
            builder.command("cmd.exe", "/c", command);
        } else {
            builder.command("sh", "-c", command);
        }
        builder.directory(new File(System.getProperty("user.home")));
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error in executing protoc command '" + command + "'.", e);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new CodeGeneratorException("Process not successfully completed. Process is interrupted while running the protoc executor.", e);
        }
        if (process.exitValue() != 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    try {
                        String err;
                        StringBuilder errMsg = new StringBuilder();
                        while ((err = bufferedReader.readLine()) != null) {
                            errMsg.append(System.lineSeparator()).append(err);
                        }
                        throw new CodeGeneratorException(errMsg.toString());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (bufferedReader != null) {
                        if (throwable != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            bufferedReader.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new CodeGeneratorException("Invalid command syntax.", e);
            }
        }
    }

    public static String resolveProtoFolderPath(String protoPath) {
        int idx = protoPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR);
        String protoFolderPath = "";
        if (idx > 0) {
            protoFolderPath = protoPath.substring(0, idx);
        }
        return protoFolderPath;
    }

    public static void delete(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            String[] files = file.list();
            if (files != null && files.length != 0) {
                for (String temp : files) {
                    File fileDelete = new File(file, temp);
                    if (fileDelete.isDirectory()) {
                        BalFileGenerationUtils.delete(fileDelete);
                    }
                    if (!fileDelete.delete()) continue;
                    LOG.debug("Successfully deleted file " + file.toString());
                }
            }
            if (file.delete()) {
                LOG.debug("Successfully deleted file " + file.toString());
            }
            if (file.getParentFile() != null && file.getParentFile().delete()) {
                LOG.debug("Successfully deleted parent file " + file.toString());
            }
        } else if (file != null && file.delete()) {
            LOG.debug("Successfully deleted parent file " + file.toString());
        }
    }

    public static void downloadFile(URL url, File file) throws CodeGeneratorException {
        try (InputStream in = url.openStream();
             FileOutputStream fos = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > -1) {
                fos.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            String msg = "Error while downloading the file: " + file.getName() + ". " + e.getMessage();
            throw new CodeGeneratorException(msg, e);
        }
    }

    public static void grantPermission(File file) throws CodeGeneratorException {
        boolean isExecutable = file.setExecutable(true);
        boolean isReadable = file.setReadable(true);
        boolean isWritable = file.setWritable(true);
        if (!(isExecutable && isReadable && isWritable)) {
            String msg = "Error while providing execute permission to protoc executor file: " + file.getName();
            throw new CodeGeneratorException(msg);
        }
        LOG.debug("Successfully granted permission for protoc exe file");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
    }
}

