/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.awslambda;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Flags;

@SupportedAnnotationPackages(value={"ballerinax/awslambda:0.0.0"})
public class AWSLambdaPlugin
extends AbstractCompilerPlugin {
    private static final String LAMBDA_OUTPUT_ZIP_FILENAME = "aws-ballerina-lambda-functions.zip";
    private static final String AWS_LAMBDA_PACKAGE_NAME = "awslambda";
    private static final String AWS_LAMBDA_PACKAGE_ORG = "ballerinax";
    private static final String LAMBDA_PROCESS_FUNCTION_NAME = "__process";
    private static final String LAMBDA_REG_FUNCTION_NAME = "__register";
    private static final String MAIN_FUNC_NAME = "main";
    private static final PrintStream OUT = System.out;
    private static List<String> generatedFuncs = new ArrayList<String>();
    private DiagnosticLog dlog;
    private SymbolTable symTable;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void setCompilerContext(CompilerContext context) {
        this.symTable = SymbolTable.getInstance((CompilerContext)context);
    }

    public void process(PackageNode packageNode) {
        ArrayList<BLangFunction> lambdaFunctions = new ArrayList<BLangFunction>();
        for (FunctionNode fn : packageNode.getFunctions()) {
            BLangFunction bfn = (BLangFunction)fn;
            if (!this.isLambdaFunction(bfn)) continue;
            lambdaFunctions.add(bfn);
        }
        BLangPackage myPkg = (BLangPackage)packageNode;
        if (!lambdaFunctions.isEmpty()) {
            BPackageSymbol lambdaPkgSymbol = this.extractLambdaPackageSymbol(myPkg);
            if (lambdaPkgSymbol == null) {
                throw new BallerinaException("AWS Lambda package symbol cannot be found");
            }
            BLangFunction epFunc = this.extractMainFunction(myPkg);
            if (epFunc == null) {
                epFunc = this.createFunction(myPkg.pos, MAIN_FUNC_NAME, myPkg);
                packageNode.addFunction((FunctionNode)epFunc);
            } else {
                ((BLangBlockFunctionBody)epFunc.body).stmts.clear();
            }
            BLangBlockFunctionBody body = (BLangBlockFunctionBody)epFunc.body;
            for (BLangFunction lambdaFunc : lambdaFunctions) {
                this.addRegisterCall(myPkg.pos, lambdaPkgSymbol, body, lambdaFunc, myPkg);
                generatedFuncs.add(lambdaFunc.name.value);
            }
            this.addProcessCall(myPkg.pos, lambdaPkgSymbol, body);
        }
    }

    private String generateProxyFunctionName(BLangFunction targetFunc) {
        return "__func_proxy__" + targetFunc.name.value;
    }

    private BLangFunction createProxyFunction(DiagnosticPos pos, BLangPackage myPkg, BLangFunction targetFunc) {
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        paramNames.add(((BLangSimpleVariable)targetFunc.requiredParams.get((int)0)).name.value);
        paramNames.add(((BLangSimpleVariable)targetFunc.requiredParams.get((int)1)).name.value);
        paramTypes.add(((BLangSimpleVariable)targetFunc.requiredParams.get((int)0)).type);
        paramTypes.add(this.symTable.anydataType);
        BLangType retType = targetFunc.returnTypeNode;
        BLangFunction func = this.createFunction(pos, this.generateProxyFunctionName(targetFunc), paramNames, paramTypes, retType, myPkg);
        BLangSimpleVarRef arg1 = this.createVariableRef(pos, (BSymbol)((BLangSimpleVariable)func.requiredParams.get((int)0)).symbol);
        BLangSimpleVarRef arg2 = this.createVariableRef(pos, (BSymbol)((BLangSimpleVariable)func.requiredParams.get((int)1)).symbol);
        BLangInvocation inv = this.createInvocationNode((BSymbol)targetFunc.symbol, new BLangExpression[]{arg1, arg2});
        BLangReturn ret = new BLangReturn();
        ret.pos = pos;
        ret.type = retType.type;
        ret.expr = inv;
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)func.body;
        body.addStatement((StatementNode)ret);
        return func;
    }

    private BLangFunction extractMainFunction(BLangPackage myPkg) {
        for (BLangFunction func : myPkg.getFunctions()) {
            if (!MAIN_FUNC_NAME.equals(func.getName().value)) continue;
            return func;
        }
        return null;
    }

    private BPackageSymbol extractLambdaPackageSymbol(BLangPackage myPkg) {
        for (BLangImportPackage pi : myPkg.imports) {
            if (!AWS_LAMBDA_PACKAGE_ORG.equals(pi.orgName.value) || pi.pkgNameComps.size() != 1 || !AWS_LAMBDA_PACKAGE_NAME.equals(((BLangIdentifier)pi.pkgNameComps.get((int)0)).value)) continue;
            return pi.symbol;
        }
        return null;
    }

    private void addRegisterCall(DiagnosticPos pos, BPackageSymbol lamdaPkgSymbol, BLangBlockFunctionBody blockStmt, BLangFunction targetFunc, BLangPackage myPkg) {
        BLangFunction proxyFunc = this.createProxyFunction(pos, myPkg, targetFunc);
        myPkg.addFunction((FunctionNode)proxyFunc);
        ArrayList<BLangExpression> exprs = new ArrayList<BLangExpression>();
        exprs.add((BLangExpression)this.createStringLiteral(pos, targetFunc.name.value));
        exprs.add((BLangExpression)this.createVariableRef(pos, (BSymbol)proxyFunc.symbol));
        exprs.add((BLangExpression)this.createTypeDescExpr(pos, this.getEventType(targetFunc)));
        BLangInvocation inv = this.createInvocationNode(lamdaPkgSymbol, LAMBDA_REG_FUNCTION_NAME, exprs);
        BLangExpressionStmt stmt = new BLangExpressionStmt((BLangExpression)inv);
        stmt.pos = pos;
        blockStmt.addStatement((StatementNode)stmt);
    }

    private BLangLiteral createStringLiteral(DiagnosticPos pos, String value) {
        BLangLiteral stringLit = new BLangLiteral();
        stringLit.pos = pos;
        stringLit.value = value;
        stringLit.type = this.symTable.stringType;
        return stringLit;
    }

    private BLangTypedescExpr createTypeDescExpr(DiagnosticPos pos, BType type) {
        BLangTypedescExpr typeDescExpr = new BLangTypedescExpr();
        typeDescExpr.pos = pos;
        typeDescExpr.type = this.symTable.typeDesc;
        typeDescExpr.resolvedType = type;
        typeDescExpr.expectedType = this.symTable.typeDesc;
        return typeDescExpr;
    }

    private BLangSimpleVarRef createVariableRef(DiagnosticPos pos, BSymbol varSymbol) {
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        varRef.pos = pos;
        varRef.variableName = ASTBuilderUtil.createIdentifier((DiagnosticPos)pos, (String)varSymbol.name.value);
        varRef.symbol = varSymbol;
        varRef.type = varSymbol.type;
        return varRef;
    }

    private void addProcessCall(DiagnosticPos pos, BPackageSymbol lamdaPkgSymbol, BLangBlockFunctionBody blockStmt) {
        BLangInvocation inv = this.createInvocationNode(lamdaPkgSymbol, LAMBDA_PROCESS_FUNCTION_NAME, new ArrayList<BLangExpression>(0));
        BLangExpressionStmt stmt = new BLangExpressionStmt((BLangExpression)inv);
        stmt.pos = pos;
        blockStmt.addStatement((StatementNode)stmt);
    }

    private BLangInvocation createInvocationNode(BPackageSymbol pkgSymbol, String functionName, List<BLangExpression> args) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.symbol = pkgSymbol.scope.lookup((Name)new Name((String)functionName)).symbol;
        invocationNode.type = new BNilType();
        invocationNode.requiredArgs = args;
        return invocationNode;
    }

    private BLangInvocation createInvocationNode(BSymbol funcSymbol, BLangExpression ... args) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(funcSymbol.name.value);
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.symbol = funcSymbol;
        invocationNode.type = funcSymbol.getType().getReturnType();
        invocationNode.requiredArgs = Arrays.asList(args);
        return invocationNode;
    }

    private BLangFunction createFunction(DiagnosticPos pos, String name, BLangPackage packageNode) {
        BLangFunction bLangFunction = (BLangFunction)TreeBuilder.createFunctionNode();
        BLangIdentifier funcName = ASTBuilderUtil.createIdentifier((DiagnosticPos)pos, (String)name);
        bLangFunction.setName((IdentifierNode)funcName);
        bLangFunction.flagSet = EnumSet.of(Flag.PUBLIC);
        bLangFunction.pos = pos;
        bLangFunction.type = new BInvokableType(new ArrayList(), (BType)new BNilType(), null);
        bLangFunction.body = this.createBlockStmt(pos);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol((int)Flags.asMask((Set)bLangFunction.flagSet), (Name)new Name(bLangFunction.name.value), (PackageID)packageNode.packageID, (BType)bLangFunction.type, (BSymbol)packageNode.symbol, (boolean)true);
        functionSymbol.scope = new Scope((BSymbol)functionSymbol);
        bLangFunction.symbol = functionSymbol;
        return bLangFunction;
    }

    private BLangFunction createFunction(DiagnosticPos pos, String name, List<String> paramNames, List<BType> paramTypes, BLangType retType, BLangPackage packageNode) {
        BLangFunction bLangFunction = (BLangFunction)TreeBuilder.createFunctionNode();
        BLangIdentifier funcName = ASTBuilderUtil.createIdentifier((DiagnosticPos)pos, (String)name);
        bLangFunction.setName((IdentifierNode)funcName);
        bLangFunction.flagSet = EnumSet.of(Flag.PUBLIC);
        bLangFunction.pos = pos;
        bLangFunction.type = new BInvokableType(paramTypes, retType.type, null);
        bLangFunction.body = this.createBlockStmt(pos);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol((int)Flags.asMask((Set)bLangFunction.flagSet), (Name)new Name(bLangFunction.name.value), (PackageID)packageNode.packageID, (BType)bLangFunction.type, (BSymbol)packageNode.symbol, (boolean)true);
        functionSymbol.type = bLangFunction.type;
        functionSymbol.retType = retType.type;
        functionSymbol.scope = new Scope((BSymbol)functionSymbol);
        bLangFunction.symbol = functionSymbol;
        for (int i = 0; i < paramNames.size(); ++i) {
            BLangSimpleVariable var = AWSLambdaPlugin.createVariable(pos, paramTypes.get(i), paramNames.get(i), (BSymbol)bLangFunction.symbol);
            bLangFunction.addParameter((SimpleVariableNode)var);
            functionSymbol.params.add(var.symbol);
        }
        bLangFunction.setReturnTypeNode((TypeNode)retType);
        return bLangFunction;
    }

    public static BLangSimpleVariable createVariable(DiagnosticPos pos, BType type, String name, BSymbol owner) {
        BLangSimpleVariable var = (BLangSimpleVariable)TreeBuilder.createSimpleVariableNode();
        var.pos = pos;
        var.name = ASTBuilderUtil.createIdentifier((DiagnosticPos)pos, (String)name);
        var.type = type;
        var.symbol = new BVarSymbol(0, new Name(name), type.tsymbol.pkgID, type, owner);
        return var;
    }

    private BLangFunctionBody createBlockStmt(DiagnosticPos pos) {
        BLangFunctionBody blockNode = (BLangFunctionBody)TreeBuilder.createBlockFunctionBodyNode();
        blockNode.pos = pos;
        return blockNode;
    }

    private boolean isLambdaFunction(BLangFunction fn) {
        AnnotationAttachmentNode attachmentNode;
        List annotations = fn.annAttachments;
        boolean hasLambdaAnnon = false;
        Iterator iterator = annotations.iterator();
        while (iterator.hasNext() && !(hasLambdaAnnon = this.hasLambaAnnotation(attachmentNode = (AnnotationAttachmentNode)iterator.next()))) {
        }
        if (hasLambdaAnnon) {
            BLangFunction bfn = fn;
            if (!this.validateLambdaFunction(bfn)) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)fn.getPosition(), (CharSequence)("Invalid function signature for an AWS lambda function: " + bfn + ", it should be 'public function (awslambda:Context, anydata) returns json|error'"));
                return false;
            }
            return true;
        }
        return false;
    }

    private BType getEventType(BLangFunction node) {
        return ((BLangSimpleVariable)node.requiredParams.get((int)1)).type;
    }

    private boolean validateLambdaFunction(BLangFunction node) {
        ArrayList<BLangSimpleVariable> defaultableParams = new ArrayList<BLangSimpleVariable>();
        for (BLangSimpleVariable var : node.requiredParams) {
            if (!var.symbol.defaultableParam) continue;
            defaultableParams.add(var);
        }
        if (node.requiredParams.size() != 2 || defaultableParams.size() > 0 || node.restParam != null) {
            return false;
        }
        BLangType type1 = ((BLangSimpleVariable)node.requiredParams.get(0)).getTypeNode();
        BLangType type2 = ((BLangSimpleVariable)node.requiredParams.get(1)).getTypeNode();
        if (!type1.type.tsymbol.name.value.equals("Context")) {
            return false;
        }
        if (!type1.type.tsymbol.pkgID.orgName.value.equals(AWS_LAMBDA_PACKAGE_ORG) || !type1.type.tsymbol.pkgID.name.value.equals(AWS_LAMBDA_PACKAGE_NAME)) {
            return false;
        }
        if (type2 == null) {
            return false;
        }
        BLangType retType = node.returnTypeNode;
        if (retType instanceof BLangUnionTypeNode) {
            BLangUnionTypeNode unionType = (BLangUnionTypeNode)retType;
            HashSet<Integer> typeTags = new HashSet<Integer>();
            for (BLangType memberTypeNode : unionType.memberTypeNodes) {
                typeTags.add(memberTypeNode.type.tag);
            }
            typeTags.remove(7);
            typeTags.remove(27);
            typeTags.remove(10);
            if (!typeTags.isEmpty()) {
                return false;
            }
        } else if (retType.type.tag != 7 && retType.type.tag != 27 && retType.type.tag != 10) {
            return false;
        }
        return true;
    }

    private boolean hasLambaAnnotation(AnnotationAttachmentNode attachmentNode) {
        BAnnotationSymbol symbol = ((BLangAnnotationAttachment)attachmentNode).annotationSymbol;
        return AWS_LAMBDA_PACKAGE_ORG.equals(symbol.pkgID.orgName.value) && AWS_LAMBDA_PACKAGE_NAME.equals(symbol.pkgID.name.value) && "Function".equals(symbol.name.value);
    }

    public void codeGenerated(PackageID packageID, Path binaryPath) {
        if (generatedFuncs.isEmpty()) {
            return;
        }
        OUT.println("\t@awslambda:Function: " + String.join((CharSequence)", ", generatedFuncs));
        try {
            this.generateZipFile(binaryPath);
        }
        catch (IOException e) {
            throw new BallerinaException("Error generating AWS lambda zip file: " + e.getMessage(), (Throwable)e);
        }
        String balxName = binaryPath.getFileName().toString().split("\\.")[0];
        OUT.println("\n\tRun the following command to deploy each Ballerina AWS Lambda function:");
        OUT.println("\taws lambda create-function --function-name $FUNCTION_NAME --zip-file fileb://aws-ballerina-lambda-functions.zip --handler " + balxName + ".$FUNCTION_NAME --runtime provided --role $LAMBDA_ROLE_ARN --layers arn:aws:lambda:$REGION_ID:141896495686:layer:ballerina:2 --memory-size 512 --timeout 10");
        OUT.println("\n\tRun the following command to re-deploy an updated Ballerina AWS Lambda function:");
        OUT.println("\taws lambda update-function-code --function-name $FUNCTION_NAME --zip-file fileb://aws-ballerina-lambda-functions.zip");
    }

    private void generateZipFile(Path binaryPath) throws IOException {
        Path path = binaryPath.toAbsolutePath().getParent().resolve(LAMBDA_OUTPUT_ZIP_FILENAME);
        Files.deleteIfExists(path);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            Path pathInZipfile = zipfs.getPath("/" + binaryPath.getFileName(), new String[0]);
            Files.copy(binaryPath, pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

