/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.messaging.rabbitmq.RabbitMQConnectorException;
import org.ballerinalang.messaging.rabbitmq.RabbitMQConstants;
import org.ballerinalang.messaging.rabbitmq.RabbitMQErrorResourceCallback;
import org.ballerinalang.messaging.rabbitmq.RabbitMQResourceCallback;
import org.ballerinalang.messaging.rabbitmq.RabbitMQUtils;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQMetricsUtil;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQObserverContext;

public class MessageDispatcher {
    private String consumerTag;
    private static final PrintStream console = System.out;
    private Channel channel;
    private boolean autoAck;
    private ObjectValue service;
    private String queueName;
    private BRuntime runtime;

    public MessageDispatcher(ObjectValue service, Channel channel, boolean autoAck, BRuntime runtime) {
        this.channel = channel;
        this.autoAck = autoAck;
        this.service = service;
        this.queueName = this.getQueueNameFromConfig(service);
        this.consumerTag = service.getType().getName();
        this.runtime = runtime;
    }

    private String getQueueNameFromConfig(ObjectValue service) {
        MapValue serviceConfig = (MapValue)service.getType().getAnnotation("ballerina/rabbitmq", "ServiceConfig");
        MapValue queueConfig = serviceConfig.getMapValue("queueConfig");
        return queueConfig.getStringValue("queueName");
    }

    public void receiveMessages(ObjectValue listener) {
        console.println("[ballerina/rabbitmq] Consumer service started for queue " + this.queueName);
        DefaultConsumer consumer = new DefaultConsumer(this.channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                MessageDispatcher.this.handleDispatch(body, envelope.getDeliveryTag(), properties);
            }
        };
        try {
            this.channel.basicConsume(this.queueName, this.autoAck, this.consumerTag, (Consumer)consumer);
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError(this.channel, "consume");
            throw RabbitMQUtils.returnErrorValue("Error occurred while consuming messages; " + exception.getMessage());
        }
        ArrayList startedServices = (ArrayList)listener.getNativeData("started_services");
        startedServices.add(this.service);
        this.service.addNativeData("queueName", (Object)this.queueName);
    }

    private void handleDispatch(byte[] message, long deliveryTag, AMQP.BasicProperties properties) {
        AttachedFunction onMessageFunction;
        AttachedFunction[] attachedFunctions = this.service.getType().getAttachedFunctions();
        if ("onMessage".equals(attachedFunctions[0].getName())) {
            onMessageFunction = attachedFunctions[0];
        } else if ("onMessage".equals(attachedFunctions[1].getName())) {
            onMessageFunction = attachedFunctions[1];
        } else {
            return;
        }
        BType[] paramTypes = onMessageFunction.getParameterType();
        int paramSize = paramTypes.length;
        if (paramSize > 1) {
            this.dispatchMessageWithDataBinding(message, deliveryTag, onMessageFunction, properties);
        } else {
            this.dispatchMessage(message, deliveryTag, properties);
        }
    }

    private void dispatchMessage(byte[] message, long deliveryTag, AMQP.BasicProperties properties) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            RabbitMQResourceCallback callback = new RabbitMQResourceCallback(countDownLatch, this.channel, this.queueName, message.length);
            ObjectValue messageObjectValue = this.getMessageObjectValue(message, deliveryTag, properties);
            this.executeResource("onMessage", callback, messageObjectValue, true);
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            RabbitMQMetricsUtil.reportError(this.channel, "consume");
            Thread.currentThread().interrupt();
            throw new RabbitMQConnectorException("Error occurred in RabbitMQ service. The current thread got interrupted");
        }
        catch (AlreadyClosedException | BallerinaConnectorException exception) {
            RabbitMQMetricsUtil.reportError(this.channel, "consume");
            this.handleError(message, deliveryTag, properties);
        }
    }

    private void dispatchMessageWithDataBinding(byte[] message, long deliveryTag, AttachedFunction onMessage, AMQP.BasicProperties properties) {
        BType[] paramTypes = onMessage.getParameterType();
        try {
            Object forContent = this.getMessageContentForType(message, paramTypes[1]);
            ObjectValue messageObjectValue = this.getMessageObjectValue(message, deliveryTag, properties);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            RabbitMQResourceCallback callback = new RabbitMQResourceCallback(countDownLatch, this.channel, this.queueName, message.length);
            this.executeResource("onMessage", callback, messageObjectValue, true, forContent, true);
            countDownLatch.await();
        }
        catch (UnsupportedEncodingException | BallerinaConnectorException exception) {
            RabbitMQMetricsUtil.reportError(this.channel, "consume");
            this.handleError(message, deliveryTag, properties);
        }
        catch (InterruptedException e) {
            RabbitMQMetricsUtil.reportError(this.channel, "consume");
            Thread.currentThread().interrupt();
            throw new RabbitMQConnectorException("Error occurred in RabbitMQ service. The current thread got interrupted");
        }
    }

    private Object getMessageContentForType(byte[] message, BType dataType) throws UnsupportedEncodingException {
        int dataTypeTag = dataType.getTag();
        switch (dataTypeTag) {
            case 5: {
                return new String(message, StandardCharsets.UTF_8.name());
            }
            case 7: {
                return JSONParser.parse((String)new String(message, StandardCharsets.UTF_8.name()));
            }
            case 8: {
                return XMLFactory.parse((String)new String(message, StandardCharsets.UTF_8.name()));
            }
            case 3: {
                return Float.valueOf(Float.parseFloat(new String(message, StandardCharsets.UTF_8.name())));
            }
            case 1: {
                return Integer.parseInt(new String(message, StandardCharsets.UTF_8.name()));
            }
            case 12: {
                return JSONUtils.convertJSONToRecord((Object)JSONParser.parse((String)new String(message, StandardCharsets.UTF_8.name())), (BStructureType)((BStructureType)dataType));
            }
            case 20: {
                if (((BArrayType)dataType).getElementType().getTag() == 2) {
                    return message;
                }
                RabbitMQMetricsUtil.reportError(this.channel, "consume");
                throw new RabbitMQConnectorException("Only type byte[] is supported in data binding.");
            }
        }
        RabbitMQMetricsUtil.reportError(this.channel, "consume");
        throw new RabbitMQConnectorException("The content type of the message received does not match the resource signature type.");
    }

    private ObjectValue getMessageObjectValue(byte[] message, long deliveryTag, AMQP.BasicProperties properties) {
        ObjectValue messageObjectValue = BallerinaValues.createObjectValue((BPackage)RabbitMQConstants.PACKAGE_ID_RABBITMQ, (String)"Message", (Object[])new Object[0]);
        messageObjectValue.set("deliveryTag", (Object)deliveryTag);
        messageObjectValue.set("amqpChannel", (Object)new HandleValue((Object)this.channel));
        messageObjectValue.set("messageContent", (Object)BValueCreator.createArrayValue((byte[])message));
        messageObjectValue.set("autoAck", (Object)this.autoAck);
        messageObjectValue.set("ackStatus", (Object)false);
        if (properties != null) {
            String replyTo = properties.getReplyTo();
            String contentType = properties.getContentType();
            String contentEncoding = properties.getContentEncoding();
            String correlationId = properties.getCorrelationId();
            MapValue basicProperties = BallerinaValues.createRecordValue((BPackage)RabbitMQConstants.PACKAGE_ID_RABBITMQ, (String)"BasicProperties");
            Object[] values = new Object[]{replyTo, contentType, contentEncoding, correlationId};
            messageObjectValue.set("properties", (Object)BallerinaValues.createRecord((MapValue)basicProperties, (Object[])values));
        }
        return messageObjectValue;
    }

    private void handleError(byte[] message, long deliveryTag, AMQP.BasicProperties properties) {
        ErrorValue error = RabbitMQUtils.returnErrorValue("Error occurred while dispatching the message. ");
        ObjectValue messageObjectValue = this.getMessageObjectValue(message, deliveryTag, properties);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            RabbitMQErrorResourceCallback callback = new RabbitMQErrorResourceCallback(countDownLatch);
            this.executeResource("onError", callback, messageObjectValue, true, error, true);
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            RabbitMQMetricsUtil.reportError(this.channel, "consume");
            throw new RabbitMQConnectorException("Error occurred in RabbitMQ service. The current thread got interrupted");
        }
        catch (AlreadyClosedException | BallerinaConnectorException exception) {
            RabbitMQMetricsUtil.reportError(this.channel, "consume");
            throw new RabbitMQConnectorException("Error occurred in RabbitMQ service. ");
        }
    }

    private void executeResource(String function, CallableUnitCallback callback, Object ... args) {
        if (ObserveUtils.isTracingEnabled()) {
            this.runtime.invokeMethodAsync(this.service, function, callback, this.getNewObserverContextInProperties(), args);
            return;
        }
        this.runtime.invokeMethodAsync(this.service, function, callback, args);
    }

    private Map<String, Object> getNewObserverContextInProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(this.channel);
        observerContext.addTag("queue", this.queueName);
        properties.put("__observer_context__", (Object)observerContext);
        return properties;
    }
}

