/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq.util;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.rabbitmq.RabbitMQConnectorException;
import org.ballerinalang.messaging.rabbitmq.RabbitMQConstants;
import org.ballerinalang.messaging.rabbitmq.RabbitMQUtils;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQMetricsUtil;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQTracingUtil;

public class ChannelUtils {
    public static Channel createChannel(Connection connection) {
        try {
            Channel channel = connection.createChannel();
            RabbitMQMetricsUtil.reportNewChannel(channel);
            return channel;
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError(connection, "channel_create");
            throw RabbitMQUtils.returnErrorValue("Error occurred while initializing the channel: " + exception.getMessage());
        }
    }

    public static Object queueDeclare(Object queueConfig, Channel channel) {
        try {
            if (queueConfig == null) {
                RabbitMQMetricsUtil.reportNewQueue(channel, "unknown");
                return channel.queueDeclare().getQueue();
            }
            MapValue config = (MapValue)queueConfig;
            String queueName = config.getStringValue("queueName");
            boolean durable = config.getBooleanValue("durable");
            boolean exclusive = config.getBooleanValue("exclusive");
            boolean autoDelete = config.getBooleanValue("autoDelete");
            HashMap argumentsMap = null;
            if (config.getMapValue("arguments") != null) {
                argumentsMap = (HashMap)config.getMapValue("arguments");
            }
            channel.queueDeclare(queueName, durable, exclusive, autoDelete, (Map)argumentsMap);
            RabbitMQMetricsUtil.reportNewQueue(channel, queueName);
            RabbitMQTracingUtil.traceQueueResourceInvocation(channel, queueName);
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError(channel, "queue_declare");
            return RabbitMQUtils.returnErrorValue("Error occurred while declaring the queue: " + exception.getMessage());
        }
        return null;
    }

    public static Object exchangeDeclare(MapValue<String, Object> exchangeConfig, Channel channel) {
        RabbitMQTracingUtil.traceResourceInvocation(channel);
        try {
            String exchangeName = exchangeConfig.getStringValue("exchangeName");
            String exchangeType = exchangeConfig.getStringValue("exchangeType");
            boolean durable = exchangeConfig.getBooleanValue("durable");
            boolean autoDelete = exchangeConfig.getBooleanValue("autoDelete");
            HashMap argumentsMap = null;
            if (exchangeConfig.getMapValue("arguments") != null) {
                argumentsMap = (HashMap)exchangeConfig.getMapValue("arguments");
            }
            channel.exchangeDeclare(exchangeName, exchangeType, durable, autoDelete, (Map)argumentsMap);
            RabbitMQMetricsUtil.reportNewExchange(channel, exchangeName);
            RabbitMQTracingUtil.traceExchangeResourceInvocation(channel, exchangeName);
        }
        catch (IOException | RabbitMQConnectorException exception) {
            RabbitMQMetricsUtil.reportError(channel, "exchange_declare");
            return RabbitMQUtils.returnErrorValue("Error occurred while declaring the exchange: " + ((Throwable)exception).getMessage());
        }
        return null;
    }

    public static Object queueBind(String queueName, String exchangeName, String bindingKey, Channel channel) {
        try {
            channel.queueBind(queueName, exchangeName, bindingKey, null);
            RabbitMQTracingUtil.traceResourceInvocation(channel);
            RabbitMQTracingUtil.traceQueueBindResourceInvocation(channel, queueName, exchangeName, bindingKey);
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError(channel, "queue_bind");
            return RabbitMQUtils.returnErrorValue("Error occurred while binding the queue: " + exception.getMessage());
        }
        return null;
    }

    public static Object basicPublish(Object messageContent, String routingKey, String exchangeName, Object properties, Channel channel) {
        String defaultExchangeName = "";
        if (exchangeName != null) {
            defaultExchangeName = exchangeName;
        }
        try {
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
            if (properties != null) {
                MapValue basicPropsMap = (MapValue)properties;
                String replyTo = basicPropsMap.getStringValue("replyTo");
                String contentType = basicPropsMap.getStringValue("contentType");
                String contentEncoding = basicPropsMap.getStringValue("contentEncoding");
                String correlationId = basicPropsMap.getStringValue("correlationId");
                if (replyTo != null) {
                    builder.replyTo(replyTo);
                }
                if (contentType != null) {
                    builder.contentType(contentType);
                }
                if (contentEncoding != null) {
                    builder.contentEncoding(contentEncoding);
                }
                if (correlationId != null) {
                    builder.correlationId(correlationId);
                }
            }
            AMQP.BasicProperties basicProps = builder.build();
            byte[] messageContentBytes = messageContent.toString().getBytes(StandardCharsets.UTF_8);
            channel.basicPublish(defaultExchangeName, routingKey, basicProps, messageContentBytes);
            RabbitMQMetricsUtil.reportPublish(channel, defaultExchangeName, routingKey, messageContentBytes.length);
            RabbitMQTracingUtil.tracePublishResourceInvocation(channel, defaultExchangeName, routingKey);
        }
        catch (IOException | RabbitMQConnectorException exception) {
            RabbitMQMetricsUtil.reportError(channel, "publish");
            return RabbitMQUtils.returnErrorValue("Error occurred while publishing the message: " + ((Throwable)exception).getMessage());
        }
        return null;
    }

    public static Object queueDelete(String queueName, boolean ifUnused, boolean ifEmpty, Channel channel) {
        try {
            channel.queueDelete(queueName, ifUnused, ifEmpty);
            RabbitMQMetricsUtil.reportQueueDeletion(channel, queueName);
            RabbitMQTracingUtil.traceQueueResourceInvocation(channel, queueName);
        }
        catch (IOException | RabbitMQConnectorException exception) {
            RabbitMQMetricsUtil.reportError(channel, "queue_delete");
            return RabbitMQUtils.returnErrorValue("Error occurred while deleting the queue: " + ((Throwable)exception).getMessage());
        }
        return null;
    }

    public static Object exchangeDelete(String exchangeName, Channel channel) {
        try {
            channel.exchangeDelete(exchangeName);
            RabbitMQMetricsUtil.reportExchangeDeletion(channel, exchangeName);
            RabbitMQTracingUtil.traceExchangeResourceInvocation(channel, exchangeName);
        }
        catch (IOException | BallerinaException exception) {
            RabbitMQMetricsUtil.reportError(channel, "exchange_delete");
            return RabbitMQUtils.returnErrorValue("Error occurred while deleting the exchange: " + exception.getMessage());
        }
        return null;
    }

    public static Object queuePurge(String queueName, Channel channel) {
        try {
            channel.queuePurge(queueName);
            RabbitMQTracingUtil.traceQueueResourceInvocation(channel, queueName);
        }
        catch (IOException | RabbitMQConnectorException exception) {
            RabbitMQMetricsUtil.reportError(channel, "queue_declare");
            return RabbitMQUtils.returnErrorValue("Error occurred while purging the queue: " + ((Throwable)exception).getMessage());
        }
        return null;
    }

    public static Object close(Object closeCode, Object closeMessage, Channel channel) {
        try {
            boolean validCloseMessage;
            boolean validCloseCode = closeCode != null && RabbitMQUtils.checkIfInt(closeCode);
            boolean bl = validCloseMessage = closeMessage != null && RabbitMQUtils.checkIfString(closeMessage);
            if (validCloseCode && validCloseMessage) {
                channel.close(((Integer)closeCode).intValue(), closeMessage.toString());
            } else {
                channel.close();
            }
            RabbitMQMetricsUtil.reportChannelClose(channel);
            RabbitMQTracingUtil.traceResourceInvocation(channel);
        }
        catch (IOException | ArithmeticException | TimeoutException | RabbitMQConnectorException exception) {
            RabbitMQMetricsUtil.reportError(channel, "channel_close");
            return RabbitMQUtils.returnErrorValue("Error occurred while closing the channel: " + ((Throwable)exception).getMessage());
        }
        return null;
    }

    public static Object abort(Object closeCode, Object closeMessage, Channel channel) {
        try {
            boolean validCloseMessage;
            boolean validCloseCode = closeCode != null && RabbitMQUtils.checkIfInt(closeCode);
            boolean bl = validCloseMessage = closeMessage != null && RabbitMQUtils.checkIfString(closeMessage);
            if (validCloseCode && validCloseMessage) {
                channel.abort(((Integer)closeCode).intValue(), closeMessage.toString());
            } else {
                channel.abort();
            }
            RabbitMQMetricsUtil.reportChannelClose(channel);
            RabbitMQTracingUtil.traceResourceInvocation(channel);
            return null;
        }
        catch (IOException | ArithmeticException | RabbitMQConnectorException exception) {
            RabbitMQMetricsUtil.reportError(channel, "abort");
            return RabbitMQUtils.returnErrorValue("Error occurred while aborting the channel: " + ((Throwable)exception).getMessage());
        }
    }

    public static Object getConnection(Channel channel) {
        try {
            Connection connection = channel.getConnection();
            ObjectValue connectionObject = BallerinaValues.createObjectValue((BPackage)RabbitMQConstants.PACKAGE_ID_RABBITMQ, (String)"Connection", (Object[])new Object[0]);
            connectionObject.addNativeData("rabbitmq_connection_object", (Object)connection);
            RabbitMQTracingUtil.traceResourceInvocation(channel);
            return connectionObject;
        }
        catch (AlreadyClosedException exception) {
            RabbitMQMetricsUtil.reportError(channel, "get_connection");
            return RabbitMQUtils.returnErrorValue("Error occurred while retrieving the connection: " + exception.getMessage());
        }
    }

    public static Object basicGet(String queueName, boolean ackMode, Channel channel) {
        try {
            GetResponse response = channel.basicGet(queueName, ackMode);
            ObjectValue messageObjectValue = ChannelUtils.createAndPopulateMessageObjectValue(response, channel, ackMode);
            RabbitMQMetricsUtil.reportConsume(channel, queueName, ((byte[])messageObjectValue.getNativeData("messageContent")).length, "channel");
            RabbitMQTracingUtil.traceQueueResourceInvocation(channel, queueName);
            return messageObjectValue;
        }
        catch (IOException e) {
            RabbitMQMetricsUtil.reportError(channel, "basic_get");
            return RabbitMQUtils.returnErrorValue("Error occurred while retrieving the message: " + e.getMessage());
        }
    }

    private static ObjectValue createAndPopulateMessageObjectValue(GetResponse response, Channel channel, boolean autoAck) {
        ObjectValue messageObjectValue = BallerinaValues.createObjectValue((BPackage)RabbitMQConstants.PACKAGE_ID_RABBITMQ, (String)"Message", (Object[])new Object[0]);
        messageObjectValue.addNativeData("deliveryTag", (Object)response.getEnvelope().getDeliveryTag());
        messageObjectValue.addNativeData("rabbitmq_channel_object", (Object)new HandleValue((Object)channel));
        messageObjectValue.addNativeData("messageContent", (Object)response.getBody());
        messageObjectValue.addNativeData("autoAck", (Object)autoAck);
        messageObjectValue.addNativeData("properties", (Object)response.getProps());
        messageObjectValue.addNativeData("ackStatus", (Object)false);
        return messageObjectValue;
    }

    private ChannelUtils() {
    }
}

