/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq.util;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.messaging.rabbitmq.RabbitMQConnectorException;
import org.ballerinalang.messaging.rabbitmq.RabbitMQUtils;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQMetricsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtils.class);

    public static Connection createConnection(MapValue<String, Object> connectionConfig) {
        try {
            Object connectionHeartBeat;
            Object shutdownTimeout;
            Object handshakeTimeout;
            Object timeout;
            Object pass;
            ConnectionFactory connectionFactory = new ConnectionFactory();
            MapValue secureSocket = connectionConfig.getMapValue("secureSocket");
            if (secureSocket != null) {
                SSLContext sslContext = ConnectionUtils.getSSLContext(secureSocket);
                connectionFactory.useSslProtocol(sslContext);
                if (secureSocket.getBooleanValue("verifyHostname").booleanValue()) {
                    connectionFactory.enableHostnameVerification();
                }
                LOGGER.info("TLS enabled for the connection.");
            }
            String host = connectionConfig.getStringValue("host");
            connectionFactory.setHost(host);
            int port = Math.toIntExact(connectionConfig.getIntValue("port"));
            connectionFactory.setPort(port);
            Object username = connectionConfig.get((Object)"username");
            if (username != null) {
                connectionFactory.setUsername(username.toString());
            }
            if ((pass = connectionConfig.get((Object)"password")) != null) {
                connectionFactory.setPassword(pass.toString());
            }
            if ((timeout = connectionConfig.get((Object)"connectionTimeoutInMillis")) != null) {
                connectionFactory.setConnectionTimeout(Integer.parseInt(timeout.toString()));
            }
            if ((handshakeTimeout = connectionConfig.get((Object)"handshakeTimeoutMillis")) != null) {
                connectionFactory.setHandshakeTimeout(Integer.parseInt(handshakeTimeout.toString()));
            }
            if ((shutdownTimeout = connectionConfig.get((Object)"shutdownTimeoutInMillis")) != null) {
                connectionFactory.setShutdownTimeout(Integer.parseInt(shutdownTimeout.toString()));
            }
            if ((connectionHeartBeat = connectionConfig.get((Object)"heartbeatInSeconds")) != null) {
                connectionFactory.setRequestedHeartbeat(Integer.parseInt(connectionHeartBeat.toString()));
            }
            Connection connection = connectionFactory.newConnection();
            RabbitMQMetricsUtil.reportNewConnection(connection);
            return connection;
        }
        catch (IOException | TimeoutException exception) {
            RabbitMQMetricsUtil.reportError("connection");
            throw new RabbitMQConnectorException("Error occurred while connecting to the broker: " + exception.getMessage(), exception);
        }
    }

    private static SSLContext getSSLContext(MapValue secureSocket) {
        try {
            MapValue cryptoKeyStore = secureSocket.getMapValue("keyStore");
            MapValue cryptoTrustStore = secureSocket.getMapValue("trustStore");
            char[] keyPassphrase = cryptoKeyStore.getStringValue("password").toCharArray();
            String keyFilePath = cryptoKeyStore.getStringValue("path");
            char[] trustPassphrase = cryptoTrustStore.getStringValue("password").toCharArray();
            String trustFilePath = cryptoTrustStore.getStringValue("path");
            String tlsVersion = secureSocket.getStringValue("tlsVersion");
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            if (keyFilePath != null) {
                try (FileInputStream keyFileInputStream = new FileInputStream(keyFilePath);){
                    keyStore.load(keyFileInputStream, keyPassphrase);
                }
            } else {
                RabbitMQMetricsUtil.reportError("connection");
                throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: Path for the keystore is not found.");
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyPassphrase);
            KeyStore trustStore = KeyStore.getInstance("PKCS12");
            if (trustFilePath != null) {
                try (FileInputStream trustFileInputStream = new FileInputStream(trustFilePath);){
                    trustStore.load(trustFileInputStream, trustPassphrase);
                }
            } else {
                RabbitMQMetricsUtil.reportError("connection");
                throw new RabbitMQConnectorException("Path for the truststore is not found.");
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(tlsVersion);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (FileNotFoundException exception) {
            throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: " + exception.getLocalizedMessage());
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError("connection");
            throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: I/O error occurred.");
        }
        catch (CertificateException exception) {
            RabbitMQMetricsUtil.reportError("connection");
            throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: Certification error occurred.");
        }
        catch (UnrecoverableKeyException exception) {
            RabbitMQMetricsUtil.reportError("connection");
            throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: A key in the keystore cannot be recovered.");
        }
        catch (NoSuchAlgorithmException exception) {
            RabbitMQMetricsUtil.reportError("connection");
            throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: The particular cryptographic algorithm requested is not available in the environment.");
        }
        catch (KeyStoreException exception) {
            RabbitMQMetricsUtil.reportError("connection");
            throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: No provider supports a KeyStoreSpi implementation for this keystore type." + exception.getLocalizedMessage());
        }
        catch (KeyManagementException exception) {
            RabbitMQMetricsUtil.reportError("connection");
            throw new RabbitMQConnectorException("An error occurred while configuring the SSL connection: Error occurred in an operation with key management." + exception.getLocalizedMessage());
        }
    }

    public static boolean isClosed(Connection connection) {
        return connection == null || !connection.isOpen();
    }

    public static Object handleCloseConnection(Object closeCode, Object closeMessage, Object timeout, Connection connection) {
        boolean validTimeout = timeout != null && RabbitMQUtils.checkIfInt(timeout);
        boolean validCloseCode = closeCode != null && RabbitMQUtils.checkIfInt(closeCode) && closeMessage != null && RabbitMQUtils.checkIfString(closeMessage);
        try {
            if (validTimeout && validCloseCode) {
                connection.close(Integer.parseInt(closeCode.toString()), closeMessage.toString(), Integer.parseInt(timeout.toString()));
            } else if (validTimeout) {
                connection.close(Integer.parseInt(timeout.toString()));
            } else if (validCloseCode) {
                connection.close(Integer.parseInt(closeCode.toString()), closeMessage.toString());
            } else {
                connection.close();
            }
            RabbitMQMetricsUtil.reportConnectionClose(connection);
        }
        catch (IOException | ArithmeticException exception) {
            RabbitMQMetricsUtil.reportError("connection_close");
            return RabbitMQUtils.returnErrorValue("Error occurred while closing the connection: " + exception.getMessage());
        }
        return null;
    }

    public static void handleAbortConnection(Object closeCode, Object closeMessage, Object timeout, Connection connection) {
        boolean validCloseCode;
        boolean validTimeout = timeout != null && RabbitMQUtils.checkIfInt(timeout);
        boolean bl = validCloseCode = closeCode != null && RabbitMQUtils.checkIfInt(closeCode) && closeMessage != null && RabbitMQUtils.checkIfString(closeMessage);
        if (validTimeout && validCloseCode) {
            connection.abort(Integer.parseInt(closeCode.toString()), closeMessage.toString(), Integer.parseInt(timeout.toString()));
        } else if (validTimeout) {
            connection.abort(Integer.parseInt(timeout.toString()));
        } else if (validCloseCode) {
            connection.abort(Integer.parseInt(closeCode.toString()), closeMessage.toString());
        } else {
            connection.abort();
        }
        RabbitMQMetricsUtil.reportConnectionClose(connection);
    }

    private ConnectionUtils() {
    }
}

