/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq.util;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.rabbitmq.MessageDispatcher;
import org.ballerinalang.messaging.rabbitmq.RabbitMQConnectorException;
import org.ballerinalang.messaging.rabbitmq.RabbitMQUtils;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQMetricsUtil;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQTracingUtil;

public class ListenerUtils {
    private static final PrintStream console;
    private static boolean started;
    private static ArrayList<ObjectValue> services;
    private static ArrayList<ObjectValue> startedServices;
    private static BRuntime runtime;

    public static void init(ObjectValue listenerObjectValue, Channel channel) {
        listenerObjectValue.addNativeData("rabbitmq_channel_object", (Object)channel);
        listenerObjectValue.addNativeData("consumer_services", services);
        listenerObjectValue.addNativeData("started_services", startedServices);
        RabbitMQMetricsUtil.reportNewConsumer(channel);
    }

    public static Object registerListener(ObjectValue listenerObjectValue, ObjectValue service) {
        runtime = BRuntime.getCurrentRuntime();
        Channel channel = (Channel)listenerObjectValue.getNativeData("rabbitmq_channel_object");
        if (service == null) {
            return null;
        }
        try {
            ListenerUtils.declareQueueIfNotExists(service, channel);
        }
        catch (IOException e) {
            RabbitMQMetricsUtil.reportError(channel, "register");
            return RabbitMQUtils.returnErrorValue("I/O Error occurred while declaring the queue: " + e.getMessage());
        }
        if (ListenerUtils.isStarted()) {
            services = (ArrayList)listenerObjectValue.getNativeData("consumer_services");
            ListenerUtils.startReceivingMessages(service, channel, listenerObjectValue);
        }
        services.add(service);
        return null;
    }

    public static Object start(ObjectValue listenerObjectValue) {
        runtime = BRuntime.getCurrentRuntime();
        ObjectValue channelObject = (ObjectValue)listenerObjectValue.get("amqpChannel");
        Channel channel = (Channel)listenerObjectValue.getNativeData("rabbitmq_channel_object");
        ArrayList services = (ArrayList)listenerObjectValue.getNativeData("consumer_services");
        ArrayList startedServices = (ArrayList)listenerObjectValue.getNativeData("started_services");
        if (services == null || services.isEmpty()) {
            return null;
        }
        for (ObjectValue service : services) {
            boolean isQosSet;
            if (startedServices != null && startedServices.contains(service)) continue;
            MapValue serviceConfig = (MapValue)service.getType().getAnnotation("ballerina/rabbitmq", "ServiceConfig");
            MapValue queueConfig = serviceConfig.getMapValue("queueConfig");
            boolean autoAck = ListenerUtils.getAckMode(service);
            boolean bl = isQosSet = channelObject.getNativeData("qos_status") != null;
            if (!isQosSet) {
                try {
                    ListenerUtils.handleBasicQos(channel, (MapValue<String, Object>)queueConfig);
                }
                catch (RabbitMQConnectorException exception) {
                    RabbitMQMetricsUtil.reportError(channel, "start");
                    return RabbitMQUtils.returnErrorValue("Error occurred while setting the QoS settings." + exception.getDetail());
                }
            }
            MessageDispatcher messageDispatcher = new MessageDispatcher(service, channel, autoAck, runtime);
            messageDispatcher.receiveMessages(listenerObjectValue);
            RabbitMQMetricsUtil.reportSubscription(channel, service);
        }
        started = true;
        return null;
    }

    public static Object detach(ObjectValue listenerObjectValue, ObjectValue service) {
        Channel channel = (Channel)listenerObjectValue.getNativeData("rabbitmq_channel_object");
        ArrayList startedServices = (ArrayList)listenerObjectValue.getNativeData("started_services");
        ArrayList services = (ArrayList)listenerObjectValue.getNativeData("consumer_services");
        String serviceName = service.getType().getName();
        String queueName = (String)service.getNativeData("queueName");
        try {
            channel.basicCancel(serviceName);
            console.println("[ballerina/rabbitmq] Consumer service unsubscribed from the queue " + queueName);
        }
        catch (IOException e) {
            RabbitMQMetricsUtil.reportError(channel, "detach");
            return RabbitMQUtils.returnErrorValue("Error occurred while detaching the service");
        }
        listenerObjectValue.addNativeData("consumer_services", RabbitMQUtils.removeFromList(services, service));
        listenerObjectValue.addNativeData("started_services", RabbitMQUtils.removeFromList(startedServices, service));
        RabbitMQMetricsUtil.reportUnsubscription(channel, service);
        RabbitMQTracingUtil.traceQueueResourceInvocation(channel, queueName);
        return null;
    }

    public static Object getChannel(ObjectValue listenerObjectValue) {
        ObjectValue channel = (ObjectValue)listenerObjectValue.get("amqpChannel");
        if (channel != null) {
            return channel;
        }
        RabbitMQMetricsUtil.reportError("get_channel");
        return RabbitMQUtils.returnErrorValue("Error occurred while retrieving the Channel, Channel is not properly initialized");
    }

    private static void declareQueueIfNotExists(ObjectValue service, Channel channel) throws IOException {
        MapValue serviceConfig = (MapValue)service.getType().getAnnotation("ballerina/rabbitmq", "ServiceConfig");
        MapValue queueConfig = serviceConfig.getMapValue("queueConfig");
        String queueName = queueConfig.getStringValue("queueName");
        boolean durable = queueConfig.getBooleanValue("durable");
        boolean exclusive = queueConfig.getBooleanValue("exclusive");
        boolean autoDelete = queueConfig.getBooleanValue("autoDelete");
        channel.queueDeclare(queueName, durable, exclusive, autoDelete, null);
        RabbitMQMetricsUtil.reportNewQueue(channel, queueName);
    }

    public static Object setQosSettings(Object prefetchCount, Object prefetchSize, ObjectValue listenerObjectValue) {
        ObjectValue channelObject = (ObjectValue)listenerObjectValue.get("amqpChannel");
        Channel channel = (Channel)listenerObjectValue.getNativeData("rabbitmq_channel_object");
        boolean isValidCount = prefetchCount != null && RabbitMQUtils.checkIfInt(prefetchCount);
        try {
            if (isValidCount) {
                boolean isValidSize;
                boolean bl = isValidSize = prefetchSize != null && RabbitMQUtils.checkIfInt(prefetchSize);
                if (isValidSize) {
                    channel.basicQos(Math.toIntExact(((Number)prefetchSize).longValue()), Math.toIntExact(((Number)prefetchCount).longValue()), true);
                    channelObject.addNativeData("qos_status", (Object)true);
                } else {
                    channel.basicQos(Math.toIntExact((Long)prefetchCount), true);
                    channelObject.addNativeData("qos_status", (Object)true);
                }
            }
        }
        catch (IOException exception) {
            RabbitMQMetricsUtil.reportError(channel, "set_qos");
            return BallerinaErrors.createError((String)"An I/O error occurred while setting the global quality of service settings for the listener");
        }
        return null;
    }

    private static void startReceivingMessages(ObjectValue service, Channel channel, ObjectValue listener) {
        MessageDispatcher messageDispatcher = new MessageDispatcher(service, channel, ListenerUtils.getAckMode(service), runtime);
        messageDispatcher.receiveMessages(listener);
    }

    private static void handleBasicQos(Channel channel, MapValue<String, Object> serviceConfig) {
        long prefetchCount = 10L;
        if (serviceConfig.getIntValue("prefetchCount") != null) {
            prefetchCount = serviceConfig.getIntValue("prefetchCount");
        }
        boolean isValidPrefetchSize = serviceConfig.getIntValue("prefetchSize") != null;
        try {
            if (isValidPrefetchSize) {
                channel.basicQos(Math.toIntExact(serviceConfig.getIntValue("prefetchSize")), Math.toIntExact(prefetchCount), false);
            } else {
                channel.basicQos(Math.toIntExact(prefetchCount));
            }
        }
        catch (IOException | ArithmeticException exception) {
            throw new RabbitMQConnectorException("An error occurred while setting the basic QoS settings; " + exception.getMessage(), exception);
        }
    }

    private static boolean isStarted() {
        return started;
    }

    private static boolean getAckMode(ObjectValue service) {
        boolean autoAck;
        String ackMode;
        MapValue serviceConfig = (MapValue)service.getType().getAnnotation("ballerina/rabbitmq", "ServiceConfig");
        switch (ackMode = serviceConfig.getStringValue("ackMode")) {
            case "auto": {
                autoAck = true;
                break;
            }
            case "client": {
                autoAck = false;
                break;
            }
            default: {
                RabbitMQMetricsUtil.reportError("start");
                throw RabbitMQUtils.returnErrorValue("Unsupported acknowledgement mode");
            }
        }
        return autoAck;
    }

    public static Object stop(ObjectValue listenerObjectValue) {
        Channel channel = (Channel)listenerObjectValue.getNativeData("rabbitmq_channel_object");
        if (channel == null) {
            RabbitMQMetricsUtil.reportError("stop");
            return RabbitMQUtils.returnErrorValue("ChannelListener is not properly initialised.");
        }
        try {
            Connection connection = channel.getConnection();
            RabbitMQMetricsUtil.reportBulkUnsubscription(channel, listenerObjectValue);
            RabbitMQMetricsUtil.reportConsumerClose(channel);
            RabbitMQMetricsUtil.reportChannelClose(channel);
            RabbitMQMetricsUtil.reportConnectionClose(connection);
            channel.close();
            connection.close();
        }
        catch (IOException | TimeoutException exception) {
            return RabbitMQUtils.returnErrorValue("An error occurred while closing the channel: " + exception.getMessage());
        }
        return null;
    }

    public static Object abortConnection(ObjectValue listenerObjectValue) {
        Channel channel = (Channel)listenerObjectValue.getNativeData("rabbitmq_channel_object");
        if (channel == null) {
            RabbitMQMetricsUtil.reportError("connection_abort");
            return RabbitMQUtils.returnErrorValue("ChannelListener is not properly initialised.");
        }
        Connection connection = channel.getConnection();
        RabbitMQMetricsUtil.reportBulkUnsubscription(channel, listenerObjectValue);
        RabbitMQMetricsUtil.reportConsumerClose(channel);
        RabbitMQMetricsUtil.reportChannelClose(channel);
        RabbitMQMetricsUtil.reportConnectionClose(connection);
        connection.abort();
        return null;
    }

    static {
        started = false;
        services = new ArrayList();
        startedServices = new ArrayList();
        console = System.out;
    }
}

