/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.ballerinalang.tool.util.BCompileUtil;

public class CommandUtil {
    private static String guessOrgName() {
        String guessOrgName = System.getProperty("user.name");
        guessOrgName = guessOrgName == null ? "my_org" : guessOrgName.toLowerCase(Locale.getDefault());
        return guessOrgName;
    }

    public static void printError(PrintStream stream, String error, String usage, boolean help) {
        stream.println("ballerina: " + error);
        if (null != usage) {
            stream.println();
            stream.println("USAGE:");
            stream.println("    " + usage);
        }
        if (help) {
            stream.println();
            stream.println("For more information try --help");
        }
    }

    public static void exitError(boolean exit) {
        if (exit) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void initProject(Path path) throws IOException {
        Path manifest = path.resolve("Ballerina.toml");
        Path src = path.resolve("src");
        Path gitignore = path.resolve(".gitignore");
        Files.createFile(manifest, new FileAttribute[0]);
        Files.createFile(gitignore, new FileAttribute[0]);
        Files.createDirectory(src, new FileAttribute[0]);
        String defaultManifest = BCompileUtil.readFileAsString((String)"new_cmd_defaults/manifest.toml");
        String defaultGitignore = BCompileUtil.readFileAsString((String)"new_cmd_defaults/gitignore");
        defaultManifest = defaultManifest.replaceAll("ORG_NAME", CommandUtil.guessOrgName());
        Files.write(manifest, defaultManifest.getBytes("UTF-8"), new OpenOption[0]);
        Files.write(gitignore, defaultGitignore.getBytes("UTF-8"), new OpenOption[0]);
    }
}

