/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.packerina.SearchUtils;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import picocli.CommandLine;

@CommandLine.Command(name="search", description={"search for modules within Ballerina Central"})
public class SearchCommand
implements BLauncherCmd {
    private static PrintStream outStream = System.err;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"search");
            outStream.println(commandUsageInfo);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.argList == null || this.argList.size() == 0) {
            throw LauncherUtils.createUsageExceptionWithHelp((String)"no keyword given");
        }
        if (this.argList.size() > 1) {
            throw LauncherUtils.createUsageExceptionWithHelp((String)"too many arguments");
        }
        String searchArgs = this.argList.get(0);
        SearchUtils.searchInCentral(searchArgs);
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "search";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("searches for modules within Ballerina Central \n");
    }

    public void printUsage(StringBuilder out) {
        out.append(" ballerina search [<org>|<module>|<text>] \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

