/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleFileContext;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleModuleContext;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.util.Lists;

public class CreateExecutableTask
implements Task {
    private static HashSet<String> excludeExtensions = new HashSet(Lists.of((Object[])new String[]{"DSA", "SF"}));

    @Override
    public void execute(BuildContext buildContext) {
        Optional<BLangPackage> modulesWithEntryPoints = buildContext.getModules().stream().filter(m -> m.symbol.entryPointExists).findAny();
        if (modulesWithEntryPoints.isPresent()) {
            buildContext.out().println();
            buildContext.out().println("Generating executables");
            for (BLangPackage module : buildContext.getModules()) {
                if (!module.symbol.entryPointExists) continue;
                Path executablePath = buildContext.getExecutablePathFromTarget(module.packageID);
                Path jarFromCachePath = buildContext.getJarPathFromTargetCache(module.packageID);
                try {
                    ZipArchiveOutputStream outStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(executablePath))));
                    Throwable throwable = null;
                    try {
                        this.assembleExecutable(jarFromCachePath, buildContext.moduleDependencyPathMap.get((Object)module.packageID).moduleLibs, outStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outStream == null) continue;
                        if (throwable != null) {
                            try {
                                outStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        outStream.close();
                    }
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException((String)("unable to extract the uber jar :" + e.getMessage()));
                }
            }
        } else {
            switch (buildContext.getSourceType()) {
                case SINGLE_BAL_FILE: {
                    SingleFileContext singleFileContext = (SingleFileContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
                    throw LauncherUtils.createLauncherException((String)("no entry points found in '" + singleFileContext.getBalFile() + "'."));
                }
                case SINGLE_MODULE: {
                    SingleModuleContext singleModuleContext = (SingleModuleContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
                    throw LauncherUtils.createLauncherException((String)("no entry points found in '" + singleModuleContext.getModuleName() + "'.\nUse `ballerina build -c` to compile the module without building executables."));
                }
                case ALL_MODULES: {
                    throw LauncherUtils.createLauncherException((String)"no entry points found in any of the modules.\nUse `ballerina build -c` to compile the modules without building executables.");
                }
            }
            throw LauncherUtils.createLauncherException((String)"unknown source type found when creating executable.");
        }
    }

    private void assembleExecutable(Path jarFromCachePath, HashSet<Path> dependencySet, ZipArchiveOutputStream outStream) {
        try {
            HashSet<String> entries = new HashSet<String>();
            HashMap<String, StringBuilder> serviceEntries = new HashMap<String, StringBuilder>();
            this.copyJarToJar(outStream, jarFromCachePath.toString(), entries, serviceEntries);
            for (Path path : dependencySet) {
                this.copyJarToJar(outStream, path.toString(), entries, serviceEntries);
            }
            for (Map.Entry entry : serviceEntries.entrySet()) {
                String s = (String)entry.getKey();
                StringBuilder service = (StringBuilder)entry.getValue();
                JarArchiveEntry e = new JarArchiveEntry(s);
                outStream.putArchiveEntry((ZipArchiveEntry)e);
                outStream.write(service.toString().getBytes(StandardCharsets.UTF_8));
                outStream.closeArchiveEntry();
            }
        }
        catch (IOException | NullPointerException e) {
            throw LauncherUtils.createLauncherException((String)("unable to create the executable: " + e.getMessage()));
        }
    }

    private void copyJarToJar(ZipArchiveOutputStream outStream, String sourceJarFile, HashSet<String> entries, HashMap<String, StringBuilder> services) throws IOException {
        ZipFile zipFile = new ZipFile(sourceJarFile);
        ZipArchiveEntryPredicate predicate = entry -> {
            String entryName = entry.getName();
            if (entryName.startsWith("META-INF/services")) {
                StringBuilder s = (StringBuilder)services.get(entryName);
                if (s == null) {
                    s = new StringBuilder();
                    services.put(entryName, s);
                }
                char c = '\n';
                BufferedInputStream inStream = null;
                try {
                    int len;
                    inStream = new BufferedInputStream(zipFile.getInputStream(entry));
                    while ((len = inStream.read()) != -1) {
                        c = (char)len;
                        s.append(c);
                    }
                    if (c != '\n') {
                        s.append('\n');
                    }
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException((String)("Error occurred while creating final executable jar due to: " + e.getMessage()));
                }
                finally {
                    if (inStream != null) {
                        this.closeStream(inStream);
                    }
                }
                return false;
            }
            if (entries.contains(entryName) || excludeExtensions.contains(entryName.substring(entryName.lastIndexOf(".") + 1))) {
                return false;
            }
            entries.add(entryName);
            return true;
        };
        zipFile.copyRawEntries(outStream, predicate);
        zipFile.close();
    }

    private void closeStream(BufferedInputStream stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("error: Failed to close input stream while creating the final executable jar.\n" + e.getMessage()));
        }
    }
}

