/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.ballerina.openapi.convertor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class ConverterUtils {
    public static Map<String, BLangExpression> listToMap(List<RecordLiteralNode.RecordField> list) {
        HashMap<String, BLangExpression> attrMap = new HashMap<String, BLangExpression>();
        for (RecordLiteralNode.RecordField field : list) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField attr = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                attrMap.put(attr.getKey().toString(), attr.getValue());
                continue;
            }
            BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
            attrMap.put(varNameField.variableName.value, (BLangExpression)varNameField);
        }
        return attrMap;
    }

    public static String getStringLiteralValue(BLangExpression valueNode) {
        if (valueNode instanceof BLangLiteral) {
            return valueNode.toString();
        }
        return null;
    }

    public static AnnotationAttachmentNode getAnnotationFromList(String name, String pkg, List<? extends AnnotationAttachmentNode> annotations) {
        AnnotationAttachmentNode annotation = null;
        if (name == null || pkg == null) {
            return null;
        }
        for (AnnotationAttachmentNode annotationAttachmentNode : annotations) {
            if (!pkg.equals(annotationAttachmentNode.getPackageAlias().getValue()) || !name.equals(annotationAttachmentNode.getAnnotationName().getValue())) continue;
            annotation = annotationAttachmentNode;
        }
        return annotation;
    }
}

